/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model;

import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.admin.api.model.AttributeMapping;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description="The Authentication Policy Contract (APC) to SP Adapter Mapping.", parent=AttributeMapping.class)
public class ApcToSpAdapterMapping
extends AttributeMapping {
    private String id;
    private String sourceId;
    private String targetId;
    private String defaultTargetResource;
    private String licenseConnectionGroupAssignment;

    @ApiModelProperty(position=40, value="The id of the Authentication Policy Contract.", required=true)
    public String getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    @ApiModelProperty(position=50, value="The id of the SP Adapter.", required=true)
    public String getTargetId() {
        return this.targetId;
    }

    public void setTargetId(String targetId) {
        this.targetId = targetId;
    }

    @ApiModelProperty(position=60, value="The id of the APC-to-SP Adapter mapping. This field is read-only and is ignored when passed in with the payload.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setId(String sourceId, String targetId) {
        this.id = ApiUtil.combineId(sourceId, targetId);
    }

    @ApiModelProperty(position=70, value="Default target URL for this APC-to-adapter mapping configuration.", required=false)
    public String getDefaultTargetResource() {
        return this.defaultTargetResource;
    }

    public void setDefaultTargetResource(String defaultTargetResource) {
        this.defaultTargetResource = defaultTargetResource;
    }

    @ApiModelProperty(position=80, value="The license connection group.")
    public String getLicenseConnectionGroupAssignment() {
        return this.licenseConnectionGroupAssignment;
    }

    public void setLicenseConnectionGroupAssignment(String licenseConnectionGroupAssignment) {
        this.licenseConnectionGroupAssignment = licenseConnectionGroupAssignment;
    }
}

