/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model;

import com.pingidentity.admin.api.model.AuthenticationPolicyContractAttribute;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ApiModel(description="Authentication Policy Contracts carry user attributes from the identity provider to the service provider.")
public class AuthenticationPolicyContract {
    private String id;
    private String name;
    private List<AuthenticationPolicyContractAttribute> coreAttributes = new ArrayList<AuthenticationPolicyContractAttribute>();
    private List<AuthenticationPolicyContractAttribute> extendedAttributes = new ArrayList<AuthenticationPolicyContractAttribute>();
    private Date lastModified;

    @ApiModelProperty(position=10, value="The persistent, unique ID for the authentication policy contract. It can be any combination of [a-zA-Z0-9._-]. This property is system-assigned if not specified.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @ApiModelProperty(position=20, value="The Authentication Policy Contract Name. Name is unique.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(position=30, value="A list of read-only assertion attributes (for example, subject) that are automatically populated by PingFederate.")
    public List<AuthenticationPolicyContractAttribute> getCoreAttributes() {
        return this.coreAttributes;
    }

    public void setCoreAttributes(List<AuthenticationPolicyContractAttribute> coreAttributes) {
        this.coreAttributes = coreAttributes;
    }

    @ApiModelProperty(position=40, value="A list of additional attributes as needed.")
    public List<AuthenticationPolicyContractAttribute> getExtendedAttributes() {
        return this.extendedAttributes;
    }

    public void setExtendedAttributes(List<AuthenticationPolicyContractAttribute> extendedAttributes) {
        this.extendedAttributes = extendedAttributes;
    }

    @ApiModelProperty(position=50, value="The time at which the authentication policy contract was last changed. This property is read only and is ignored on PUT and POST requests.")
    public Date getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return new Date(this.lastModified.getTime());
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified == null ? null : new Date(lastModified.getTime());
    }
}

