/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model;

import com.pingidentity.admin.api.model.AuthenticationSource;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.sourceid.saml20.domain.SessionTimeUnit;
import org.sourceid.saml20.domain.UserDeviceType;

@ApiModel(description="The session policy for a specified authentication source.")
public class AuthenticationSessionPolicy {
    private String id;
    private AuthenticationSource authenticationSource;
    private Boolean enableSessions;
    private UserDeviceType userDeviceType;
    private Boolean persistent;
    private Integer idleTimeoutMins;
    private Integer maxTimeoutMins;
    private SessionTimeUnit timeoutDisplayUnit;
    private boolean authnContextSensitive = false;

    public AuthenticationSessionPolicy() {
    }

    public AuthenticationSessionPolicy(String id, AuthenticationSource authenticationSource, Boolean enableSessions, Boolean persistent, Integer idleTimeoutMins, Integer maxTimeoutMins, SessionTimeUnit timeoutDisplayUnit, boolean authnContextSensitive, UserDeviceType userDeviceType) {
        this.id = id;
        this.authenticationSource = authenticationSource;
        this.enableSessions = enableSessions;
        this.persistent = persistent;
        this.idleTimeoutMins = idleTimeoutMins;
        this.maxTimeoutMins = maxTimeoutMins;
        this.timeoutDisplayUnit = timeoutDisplayUnit;
        this.authnContextSensitive = authnContextSensitive;
        this.userDeviceType = userDeviceType;
    }

    @ApiModelProperty(position=10, value="The persistent, unique ID for the session policy. It can be any combination of [a-zA-Z0-9._-]. This property is system-assigned if not specified.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @ApiModelProperty(position=20, value="The authentication source this session policy applies to. This property cannot be changed after the policy is created.", required=true)
    public AuthenticationSource getAuthenticationSource() {
        return this.authenticationSource;
    }

    public void setAuthenticationSource(AuthenticationSource authenticationSource) {
        this.authenticationSource = authenticationSource;
    }

    @ApiModelProperty(position=30, value="Determines whether sessions are enabled for the authentication source. This value overrides the enableSessions value from the global authentication session policy.", required=true)
    public Boolean isEnableSessions() {
        return this.enableSessions;
    }

    public void setEnableSessions(Boolean enableSessions) {
        this.enableSessions = enableSessions;
    }

    @ApiModelProperty(position=32, value="Determines the type of user device that the authentication session can be created on. If empty, the value will default to PRIVATE.")
    public UserDeviceType getUserDeviceType() {
        return this.userDeviceType;
    }

    public void setUserDeviceType(UserDeviceType userDeviceType) {
        this.userDeviceType = userDeviceType;
    }

    @ApiModelProperty(position=35, value="Determines whether sessions for the authentication source are persistent. This value overrides the persistentSessions value from the global authentication session policy.This field is ignored if enableSessions is false.")
    public Boolean isPersistent() {
        return this.persistent;
    }

    public void setPersistent(Boolean persistent) {
        this.persistent = persistent;
    }

    @ApiModelProperty(position=40, value="The idle timeout period, in minutes. If omitted, the value from the global authentication session policy will be used. If set to -1, the idle timeout will be set to the maximum timeout. If a value is provided for this property, a value must also be provided for maxTimeoutMins.")
    public Integer getIdleTimeoutMins() {
        return this.idleTimeoutMins;
    }

    public void setIdleTimeoutMins(Integer idleTimeoutMins) {
        this.idleTimeoutMins = idleTimeoutMins;
    }

    @ApiModelProperty(position=50, value="The maximum timeout period, in minutes. If omitted, the value from the global authentication session policy will be used. If set to -1, sessions do not expire. If a value is provided for this property, a value must also be provided for idleTimeoutMins.")
    public Integer getMaxTimeoutMins() {
        return this.maxTimeoutMins;
    }

    public void setMaxTimeoutMins(Integer maxTimeoutMins) {
        this.maxTimeoutMins = maxTimeoutMins;
    }

    @ApiModelProperty(position=55, value="The display unit for session timeout periods in the PingFederate administrative console. When the display unit is HOURS or DAYS, the timeout values in minutes must correspond to a whole number value for the specified unit.")
    public SessionTimeUnit getTimeoutDisplayUnit() {
        return this.timeoutDisplayUnit;
    }

    public void setTimeoutDisplayUnit(SessionTimeUnit timeoutDisplayUnit) {
        this.timeoutDisplayUnit = timeoutDisplayUnit;
    }

    @ApiModelProperty(position=60, value="Determines whether the requested authentication context is considered when deciding whether an existing session is valid for a given request. The default is false.")
    public boolean isAuthnContextSensitive() {
        return this.authnContextSensitive;
    }

    public void setAuthnContextSensitive(boolean authnContextSensitive) {
        this.authnContextSensitive = authnContextSensitive;
    }
}

