/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model;

import com.pingidentity.admin.api.validator.structures.UpstreamSource;
import org.sourceid.saml20.service.AuthnSourceKey;

public enum AuthenticationSourceType {
    IDP_ADAPTER,
    IDP_CONNECTION;


    public AuthnSourceKey.AuthnSourceType toDomain() {
        switch (this) {
            case IDP_ADAPTER: {
                return AuthnSourceKey.AuthnSourceType.ADAPTER;
            }
            case IDP_CONNECTION: {
                return AuthnSourceKey.AuthnSourceType.IDP_CONN;
            }
        }
        throw new RuntimeException("Unexpected AuthenticationSourceType: " + this);
    }

    public static AuthenticationSourceType fromDomain(AuthnSourceKey.AuthnSourceType domainType) {
        switch (domainType) {
            case ADAPTER: {
                return IDP_ADAPTER;
            }
            case IDP_CONN: {
                return IDP_CONNECTION;
            }
        }
        throw new RuntimeException("Unexpected AuthnSourceKey.AuthnSourceType: " + domainType);
    }

    public UpstreamSource.UpstreamSourceType toUpstreamType() {
        switch (this) {
            case IDP_ADAPTER: {
                return UpstreamSource.UpstreamSourceType.IDP_ADAPTER;
            }
            case IDP_CONNECTION: {
                return UpstreamSource.UpstreamSourceType.IDP_CONNECTION;
            }
        }
        throw new RuntimeException("Unexpected AuthenticationSourceType: " + this);
    }
}

