/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model;

import com.pingidentity.admin.api.model.CryptoProvider;
import com.pingidentity.crypto.CertificateValidity;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.List;

@ApiModel(description="Certificate details.")
@SuppressFBWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"})
public class CertView {
    private String id;
    private String serialNumber;
    private String subjectDN;
    private List<String> subjectAlternativeNames;
    private String issuerDN;
    private Date validFrom;
    private Date expires;
    private String keyAlgorithm;
    private int keySize;
    private String signatureAlgorithm;
    private int version;
    private String sha1Fingerprint;
    private String sha256Fingerprint;
    private CertificateValidity status;
    private CryptoProvider cryptoProvider;

    @ApiModelProperty(position=5, value="The persistent, unique ID for the certificate.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @ApiModelProperty(position=10, value="The serial number assigned by the CA.")
    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    @ApiModelProperty(position=20, value="The subject's distinguished name.")
    public String getSubjectDN() {
        return this.subjectDN;
    }

    public void setSubjectDN(String subjectDN) {
        this.subjectDN = subjectDN;
    }

    @ApiModelProperty(position=25, value="The subject alternative names (SAN).")
    public List<String> getSubjectAlternativeNames() {
        return this.subjectAlternativeNames;
    }

    public void setSubjectAlternativeNames(List<String> subjectAlternativeNames) {
        this.subjectAlternativeNames = subjectAlternativeNames;
    }

    @ApiModelProperty(position=30, value="The issuer's distinguished name.")
    public String getIssuerDN() {
        return this.issuerDN;
    }

    public void setIssuerDN(String issuerDN) {
        this.issuerDN = issuerDN;
    }

    @ApiModelProperty(position=40, value="The start date from which the item is valid, in ISO 8601 format (UTC).")
    public Date getValidFrom() {
        return this.validFrom;
    }

    public void setValidFrom(Date validFrom) {
        this.validFrom = validFrom;
    }

    @ApiModelProperty(position=50, value="The end date up until which the item is valid, in ISO 8601 format (UTC).")
    public Date getExpires() {
        return this.expires;
    }

    public void setExpires(Date expires) {
        this.expires = expires;
    }

    @ApiModelProperty(position=60, value="The public key algorithm.")
    public String getKeyAlgorithm() {
        return this.keyAlgorithm;
    }

    public void setKeyAlgorithm(String keyAlgorithm) {
        this.keyAlgorithm = keyAlgorithm;
    }

    @ApiModelProperty(position=70, value="The public key size.")
    public int getKeySize() {
        return this.keySize;
    }

    public void setKeySize(int keySize) {
        this.keySize = keySize;
    }

    @ApiModelProperty(position=80, value="The signature algorithm.")
    public String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public void setSignatureAlgorithm(String signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
    }

    @ApiModelProperty(position=90, value="The X.509 version to which the item conforms.")
    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    @ApiModelProperty(position=100, value="SHA-1 fingerprint in Hex encoding.")
    public String getSha1Fingerprint() {
        return this.sha1Fingerprint;
    }

    public void setSha1Fingerprint(String sha1Fingerprint) {
        this.sha1Fingerprint = sha1Fingerprint;
    }

    @ApiModelProperty(position=102, value="SHA-256 fingerprint in Hex encoding.")
    public String getSha256Fingerprint() {
        return this.sha256Fingerprint;
    }

    public void setSha256Fingerprint(String sha256Fingerprint) {
        this.sha256Fingerprint = sha256Fingerprint;
    }

    @ApiModelProperty(position=110, value="Status of the item.")
    public CertificateValidity getStatus() {
        return this.status;
    }

    public void setStatus(CertificateValidity status) {
        this.status = status;
    }

    @ApiModelProperty(position=120, value="Cryptographic Provider. This is only applicable if Hybrid HSM mode is true.")
    public CryptoProvider getCryptoProvider() {
        return this.cryptoProvider;
    }

    public void setCryptoProvider(CryptoProvider cryptoProvider) {
        this.cryptoProvider = cryptoProvider;
    }
}

