/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model;

import com.pingidentity.admin.api.model.SaasChangedUsersAlgorithm;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description="Setting to detect changes to a user or a group.")
public class ChangeDetectionSettings {
    private String userObjectClass = null;
    private String groupObjectClass = null;
    private SaasChangedUsersAlgorithm changedUsersAlgorithm = null;
    private String usnAttributeName = null;
    private String timeStampAttributeName = null;

    @ApiModelProperty(position=10, value="The user object class.", required=true)
    public String getUserObjectClass() {
        return this.userObjectClass;
    }

    public void setUserObjectClass(String userObjectClass) {
        this.userObjectClass = userObjectClass;
    }

    @ApiModelProperty(position=20, value="The group object class.", required=true)
    public String getGroupObjectClass() {
        return this.groupObjectClass;
    }

    public void setGroupObjectClass(String groupObjectClass) {
        this.groupObjectClass = groupObjectClass;
    }

    @ApiModelProperty(position=30, value="The changed user algorithm. \nACTIVE_DIRECTORY_USN - For Active Directory only, this algorithm queries for update sequence numbers on user records that are larger than the last time records were checked. \nTIMESTAMP - Queries for timestamps on user records that are not older than the last time records were checked. This check is more efficient from the point of view of the PingFederate provisioner but can be more time consuming on the LDAP side, particularly with the Oracle Directory Server. \nTIMESTAMP_NO_NEGATION - Queries for timestamps on user records that are newer than the last time records were checked. This algorithm is recommended for the Oracle Directory Server.", required=true)
    public SaasChangedUsersAlgorithm getChangedUsersAlgorithm() {
        return this.changedUsersAlgorithm;
    }

    public void setChangedUsersAlgorithm(SaasChangedUsersAlgorithm changedUsersAlgorithm) {
        this.changedUsersAlgorithm = changedUsersAlgorithm;
    }

    @ApiModelProperty(position=40, value="The USN attribute name.")
    public String getUsnAttributeName() {
        return this.usnAttributeName;
    }

    public void setUsnAttributeName(String usnAttributeName) {
        this.usnAttributeName = usnAttributeName;
    }

    @ApiModelProperty(position=50, value="The timestamp attribute name.", required=true)
    public String getTimeStampAttributeName() {
        return this.timeStampAttributeName;
    }

    public void setTimeStampAttributeName(String timeStampAttributeName) {
        this.timeStampAttributeName = timeStampAttributeName;
    }
}

