/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model;

import com.pingidentity.admin.api.model.AccountManagementSettings;
import com.pingidentity.admin.api.model.ChangeDetectionSettings;
import com.pingidentity.admin.api.model.ChannelSourceLocation;
import com.pingidentity.admin.api.model.GroupMembershipDetection;
import com.pingidentity.admin.api.model.ResourceLink;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description="The source data source and LDAP settings.")
public class ChannelSource {
    private ResourceLink dataSource;
    private String guidAttributeName;
    private boolean isGuidBinary;
    private ChangeDetectionSettings changeDetectionSettings;
    private GroupMembershipDetection groupMembershipDetection;
    private AccountManagementSettings accountManagementSettings;
    private String baseDn;
    private ChannelSourceLocation userSourceLocation;
    private ChannelSourceLocation groupSourceLocation;

    @ApiModelProperty(position=10, value="Reference to an LDAP datastore.", required=true)
    public ResourceLink getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(ResourceLink dataSource) {
        this.dataSource = dataSource;
    }

    @ApiModelProperty(position=20, value="the GUID attribute name.", required=true)
    public String getGuidAttributeName() {
        return this.guidAttributeName;
    }

    public void setGuidAttributeName(String guidAttributeName) {
        this.guidAttributeName = guidAttributeName;
    }

    @ApiModelProperty(position=30, value="Indicates whether the GUID is stored in binary format.", required=true)
    public boolean isGuidBinary() {
        return this.isGuidBinary;
    }

    public void setGuidBinary(boolean guidBinary) {
        this.isGuidBinary = guidBinary;
    }

    @ApiModelProperty(position=40, value="Settings to detect a during provisioning.", required=true)
    public ChangeDetectionSettings getChangeDetectionSettings() {
        return this.changeDetectionSettings;
    }

    public void setChangeDetectionSettings(ChangeDetectionSettings changeDetectionSettings) {
        this.changeDetectionSettings = changeDetectionSettings;
    }

    @ApiModelProperty(position=50, value="Settings to detect group memberships.", required=true)
    public GroupMembershipDetection getGroupMembershipDetection() {
        return this.groupMembershipDetection;
    }

    public void setGroupMembershipDetection(GroupMembershipDetection groupMembershipDetection) {
        this.groupMembershipDetection = groupMembershipDetection;
    }

    @ApiModelProperty(position=60, value="Account management settings that includes the status and algorithms.", required=true)
    public AccountManagementSettings getAccountManagementSettings() {
        return this.accountManagementSettings;
    }

    public void setAccountManagementSettings(AccountManagementSettings accountManagementSettings) {
        this.accountManagementSettings = accountManagementSettings;
    }

    @ApiModelProperty(position=70, value="The base DN where the user records are located.", required=true)
    public String getBaseDn() {
        return this.baseDn;
    }

    public void setBaseDn(String baseDn) {
        this.baseDn = baseDn;
    }

    @ApiModelProperty(position=80, value="The user provisioning source location settings.", required=true)
    public ChannelSourceLocation getUserSourceLocation() {
        return this.userSourceLocation;
    }

    public void setUserSourceLocation(ChannelSourceLocation userSourceLocation) {
        this.userSourceLocation = userSourceLocation;
    }

    @ApiModelProperty(position=90, value="The group provisioning source location settings.")
    public ChannelSourceLocation getGroupSourceLocation() {
        return this.groupSourceLocation;
    }

    public void setGroupSourceLocation(ChannelSourceLocation groupSourceLocation) {
        this.groupSourceLocation = groupSourceLocation;
    }
}

