/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.pingidentity.admin.api.model.AbstractIssuanceCriteriaEntry;
import com.pingidentity.admin.api.model.SourceTypeIdKey;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.sourceid.saml20.domain.ConditionType;

@ApiModel(description="An issuance criterion that checks a source attribute against a particular condition and the expected value. If the condition is true then this issuance criterion passes, otherwise the criterion fails.")
public class ConditionalIssuanceCriteriaEntry
extends AbstractIssuanceCriteriaEntry {
    private SourceTypeIdKey source;
    private String attributeName;
    private ConditionType condition;
    private String value;

    @ApiModelProperty(value="The source of the attribute.", position=10, required=true)
    public SourceTypeIdKey getSource() {
        return this.source;
    }

    public void setSource(SourceTypeIdKey source) {
        this.source = source;
    }

    @ApiModelProperty(value="The name of the attribute to use in this issuance criterion.", position=20, required=true)
    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    @ApiModelProperty(value="The condition that will be applied to the source attribute's value and the expected value.", position=30, required=true)
    public ConditionType getCondition() {
        return this.condition;
    }

    public void setCondition(ConditionType condition) {
        this.condition = condition;
    }

    @ApiModelProperty(value="The expected value of this issuance criterion.", position=40, required=true)
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    @JsonIgnore
    public boolean isCriteriaEqual(AbstractIssuanceCriteriaEntry other) {
        if (other instanceof ConditionalIssuanceCriteriaEntry) {
            ConditionalIssuanceCriteriaEntry otherEntry = (ConditionalIssuanceCriteriaEntry)other;
            return otherEntry == this || (otherEntry.attributeName == this.attributeName || this.attributeName != null && this.attributeName.equals(otherEntry.attributeName)) && otherEntry.condition == this.condition && (otherEntry.source == this.source || this.source != null && this.source.equals(otherEntry.source)) && (otherEntry.value == this.value || this.value != null && this.value.equals(otherEntry.value));
        }
        return false;
    }

    @Override
    @JsonIgnore
    public int criteriaHashCode() {
        int hash = 1;
        hash = 31 * hash + (this.attributeName == null ? 0 : this.attributeName.hashCode());
        hash = 31 * hash + (this.condition == null ? 0 : this.condition.hashCode());
        hash = 31 * hash + (this.source == null ? 0 : this.source.hashCode());
        hash = 31 * hash + (this.value == null ? 0 : this.value.hashCode());
        return hash;
    }
}

