/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model;

import com.pingidentity.admin.api.model.CertView;
import com.pingidentity.admin.api.model.X509File;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description="A certificate used for signature verification or XML encryption.")
public class ConnectionCert {
    private Boolean primaryVerificationCert;
    private Boolean secondaryVerificationCert;
    private Boolean isActiveVerificationCert;
    private Boolean isEncryptionCert = Boolean.FALSE;
    private CertView certView;
    private X509File x509File;

    @ApiModelProperty(position=10, value="Certificate details. This property is read-only and is always ignored on a POST or PUT.")
    public CertView getCertView() {
        return this.certView;
    }

    public void setCertView(CertView certView) {
        this.certView = certView;
    }

    @ApiModelProperty(position=20, required=true, value="The certificate data. This property must always be supplied on a POST or PUT.")
    public X509File getX509File() {
        return this.x509File;
    }

    public void setX509File(X509File x509File) {
        this.x509File = x509File;
    }

    @ApiModelProperty(position=25, value="Indicates whether this is an active signature verification certificate.")
    public Boolean isActiveVerificationCert() {
        return this.isActiveVerificationCert;
    }

    public void setActiveVerificationCert(Boolean isActiveVerificationCert) {
        this.isActiveVerificationCert = isActiveVerificationCert;
    }

    @ApiModelProperty(position=30, value="Indicates whether this is the primary signature verification certificate. Only one certificate in the collection can have this flag set.")
    public Boolean isPrimaryVerificationCert() {
        return this.primaryVerificationCert;
    }

    public void setPrimaryVerificationCert(Boolean primaryVerificationCert) {
        this.primaryVerificationCert = primaryVerificationCert;
    }

    @ApiModelProperty(position=40, value="Indicates whether this is the secondary signature verification certificate. Only one certificate in the collection can have this flag set.")
    public Boolean isSecondaryVerificationCert() {
        return this.secondaryVerificationCert;
    }

    public void setSecondaryVerificationCert(Boolean secondaryVerificationCert) {
        this.secondaryVerificationCert = secondaryVerificationCert;
    }

    @ApiModelProperty(position=50, value="Indicates whether to use this cert to encrypt outgoing assertions. Only one certificate in the collection can have this flag set.")
    public Boolean isEncryptionCert() {
        return this.isEncryptionCert;
    }

    public void setEncryptionCert(Boolean isEncryptionCert) {
        this.isEncryptionCert = isEncryptionCert;
    }
}

