/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model;

import com.pingidentity.admin.api.model.ConnectionCert;
import com.pingidentity.admin.api.model.InboundBackChannelAuth;
import com.pingidentity.admin.api.model.OutboundBackChannelAuth;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.SigningSettings;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;

@ApiModel(description="The certificates and settings for encryption, signing, and signature verification.")
public class ConnectionCredentials {
    private String verificationSubjectDN;
    private String verificationIssuerDN;
    private List<ConnectionCert> certs;
    private ResourceLink decryptionKeyPairRef;
    private ResourceLink sencondaryDecryptionKeyPairRef;
    private SigningSettings signingSettings;
    private String blockEncryptionAlgorithm;
    private String keyTransportAlgorithm;
    private OutboundBackChannelAuth outboundBackChannelAuth;
    private InboundBackChannelAuth inboundBackChannelAuth;

    @ApiModelProperty(position=10, value="If this property is set, the verification trust model is Anchored. The verification certificate must be signed by a trusted CA and included in the incoming message, and the subject DN of the expected certificate is specified in this property. If this property is not set, then a primary verification certificate must be specified in the certs array.")
    public String getVerificationSubjectDN() {
        return this.verificationSubjectDN;
    }

    public void setVerificationSubjectDN(String expectedSubjectDN) {
        this.verificationSubjectDN = expectedSubjectDN;
    }

    @ApiModelProperty(position=15, value="If a verification Subject DN is provided, you can optionally restrict the issuer to a specific trusted CA by specifying its DN in this field.")
    public String getVerificationIssuerDN() {
        return this.verificationIssuerDN;
    }

    public void setVerificationIssuerDN(String verificationIssuerDN) {
        this.verificationIssuerDN = verificationIssuerDN;
    }

    @ApiModelProperty(position=20, value="The certificates used for signature verification and XML encryption.")
    public List<ConnectionCert> getCerts() {
        return this.certs;
    }

    public void setCerts(List<ConnectionCert> connectionCertificates) {
        this.certs = connectionCertificates;
    }

    @ApiModelProperty(position=21, value="The algorithm used to encrypt assertions sent to this partner. AES_128, AES_256, AES_128_GCM, AES_192_GCM, AES_256_GCM and Triple_DES are supported.")
    public String getBlockEncryptionAlgorithm() {
        return this.blockEncryptionAlgorithm;
    }

    public void setBlockEncryptionAlgorithm(String blockEncryptionAlgorithm) {
        this.blockEncryptionAlgorithm = blockEncryptionAlgorithm;
    }

    @ApiModelProperty(position=22, value="The algorithm used to transport keys to this partner. RSA_OAEP, RSA_OAEP_256 and RSA_v15 are supported.")
    public String getKeyTransportAlgorithm() {
        return this.keyTransportAlgorithm;
    }

    public void setKeyTransportAlgorithm(String keyTransportAlgorithm) {
        this.keyTransportAlgorithm = keyTransportAlgorithm;
    }

    @ApiModelProperty(position=30, value="Settings related to the manner in which messages sent to the partner are digitally signed. Required for SP Connections.")
    public SigningSettings getSigningSettings() {
        return this.signingSettings;
    }

    public void setSigningSettings(SigningSettings signingSettings) {
        this.signingSettings = signingSettings;
    }

    @ApiModelProperty(position=40, value="The ID of the primary key pair used to decrypt message content received from this partner. The ID of the key pair is also known as the alias and can be found by viewing the corresponding certificate under 'Signing & Decryption Keys & Certificates' in the PingFederate Administrative Console.")
    public ResourceLink getDecryptionKeyPairRef() {
        return this.decryptionKeyPairRef;
    }

    public void setDecryptionKeyPairRef(ResourceLink decryptionKeyPairRef) {
        this.decryptionKeyPairRef = decryptionKeyPairRef;
    }

    @ApiModelProperty(position=41, value="The ID of the secondary key pair used to decrypt message content received from this partner. ")
    public ResourceLink getSecondaryDecryptionKeyPairRef() {
        return this.sencondaryDecryptionKeyPairRef;
    }

    public void setSecondaryDecryptionKeyPairRef(ResourceLink sencondaryDecryptionKeyPairRef) {
        this.sencondaryDecryptionKeyPairRef = sencondaryDecryptionKeyPairRef;
    }

    @ApiModelProperty(position=50, value="The SOAP authentication method(s) to use when you send a message using SOAP back channel.")
    public OutboundBackChannelAuth getOutboundBackChannelAuth() {
        return this.outboundBackChannelAuth;
    }

    public void setOutboundBackChannelAuth(OutboundBackChannelAuth outboundBackChannelAuth) {
        this.outboundBackChannelAuth = outboundBackChannelAuth;
    }

    @ApiModelProperty(position=60, value="The SOAP authentication method(s) to use when you receive a message using SOAP back channel.")
    public InboundBackChannelAuth getInboundBackChannelAuth() {
        return this.inboundBackChannelAuth;
    }

    public void setInboundBackChannelAuth(InboundBackChannelAuth inboundBackChannelAuth) {
        this.inboundBackChannelAuth = inboundBackChannelAuth;
    }
}

