/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.pingidentity.admin.api.model.IdentityHintAttribute;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

@ApiModel(description="A set of attributes exposed by request policy contract.")
public class IdentityHintContract {
    private List<IdentityHintAttribute> coreAttributes = new LinkedList<IdentityHintAttribute>();
    private List<IdentityHintAttribute> extendedAttributes = null;

    @ApiModelProperty(position=10, value="A list of required identity hint contract attributes.", required=true)
    public List<IdentityHintAttribute> getCoreAttributes() {
        return this.coreAttributes;
    }

    public void setCoreAttributes(List<IdentityHintAttribute> coreAttributes) {
        this.coreAttributes = coreAttributes;
    }

    @ApiModelProperty(position=20, value="A list of additional identity hint contract attributes.")
    public List<IdentityHintAttribute> getExtendedAttributes() {
        return this.extendedAttributes;
    }

    public void setExtendedAttributes(List<IdentityHintAttribute> extendedAttributes) {
        this.extendedAttributes = extendedAttributes;
    }

    @JsonIgnore
    public List<String> getAllAttributeNames() {
        ArrayList<String> allAttributeNames = new ArrayList<String>();
        for (IdentityHintAttribute coreAttribute : this.coreAttributes) {
            allAttributeNames.add(coreAttribute.getName());
        }
        if (this.extendedAttributes != null) {
            for (IdentityHintAttribute extendedAttribute : this.extendedAttributes) {
                allAttributeNames.add(extendedAttribute.getName());
            }
        }
        return allAttributeNames;
    }
}

