/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.pingidentity.admin.api.model.AdditionalAllowedEntitiesConfiguration;
import com.pingidentity.admin.api.model.BaseBrowserSso;
import com.pingidentity.admin.api.model.Connection;
import com.pingidentity.admin.api.model.ConnectionType;
import com.pingidentity.admin.api.model.IdpAttributeQuery;
import com.pingidentity.admin.api.model.IdpBrowserSso;
import com.pingidentity.admin.api.model.IdpOAuthGrantAttributeMapping;
import com.pingidentity.admin.api.model.IdpWsTrust;
import com.pingidentity.admin.api.model.OIDCClientCredentials;
import com.pingidentity.admin.api.model.Protocol;
import com.pingidentity.admin.api.model.sso.idp.IdpInboundProvisioning;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description="The set of attributes used to configure an IdP connection.", parent=Connection.class)
public class IdpConnection
extends Connection {
    private String errorPageMsgId;
    private IdpBrowserSso idpBrowserSso;
    private IdpAttributeQuery attributeQuery;
    private IdpOAuthGrantAttributeMapping idpOAuthGrantAttributeMapping;
    private OIDCClientCredentials oidcClientCredentials;
    private IdpWsTrust wsTrust;
    private IdpInboundProvisioning inboundProvisioning;

    @Override
    @ApiModelProperty(position=5, value="The type of this connection. Default is 'IDP'.")
    @JsonTypeId
    public ConnectionType getType() {
        return ConnectionType.IDP;
    }

    @ApiModelProperty(position=63, value="The OIDC client credentials. This is required for an OIDC connection.")
    public OIDCClientCredentials getOidcClientCredentials() {
        return this.oidcClientCredentials;
    }

    public void setOidcClientCredentials(OIDCClientCredentials oidcClientCredential) {
        this.oidcClientCredentials = oidcClientCredential;
    }

    @ApiModelProperty(position=65, value="The browser-based SSO settings used to communicate with your IdP.")
    public IdpBrowserSso getIdpBrowserSso() {
        return this.idpBrowserSso;
    }

    public void setIdpBrowserSso(IdpBrowserSso idpBrowserSso) {
        this.idpBrowserSso = idpBrowserSso;
    }

    @ApiModelProperty(position=66, value="The attribute query settings for requesting user attributes from an attribute authority.")
    public IdpAttributeQuery getAttributeQuery() {
        return this.attributeQuery;
    }

    public void setAttributeQuery(IdpAttributeQuery attributeQuery) {
        this.attributeQuery = attributeQuery;
    }

    @ApiModelProperty(position=1000, value="Identifier that specifies the message displayed on a user-facing error page.")
    public String getErrorPageMsgId() {
        return this.errorPageMsgId;
    }

    public void setErrorPageMsgId(String errorPageMsgId) {
        this.errorPageMsgId = errorPageMsgId;
    }

    @Override
    @JsonIgnore
    public BaseBrowserSso getBrowserSso() {
        return this.idpBrowserSso;
    }

    @ApiModelProperty(position=67, value="The OAuth Assertion Grant settings used to map from your IdP.")
    public IdpOAuthGrantAttributeMapping getIdpOAuthGrantAttributeMapping() {
        return this.idpOAuthGrantAttributeMapping;
    }

    public void setIdpOAuthGrantAttributeMapping(IdpOAuthGrantAttributeMapping idpOAuthGrantAttributeMapping) {
        this.idpOAuthGrantAttributeMapping = idpOAuthGrantAttributeMapping;
    }

    @Override
    @ApiModelProperty(position=120, value="Additional allowed entities or issuers configuration. Currently only used in OIDC IdP (RP) connection.")
    public AdditionalAllowedEntitiesConfiguration getAdditionalAllowedEntitiesConfiguration() {
        if (this.getBrowserSso() != null && this.getBrowserSso().getProtocol().equals((Object)Protocol.OIDC)) {
            return super.getAdditionalAllowedEntitiesConfiguration();
        }
        return null;
    }

    @ApiModelProperty(position=70, value="The Ws-Trust settings.")
    public IdpWsTrust getWsTrust() {
        return this.wsTrust;
    }

    public void setWsTrust(IdpWsTrust wsTrust) {
        this.wsTrust = wsTrust;
    }

    @ApiModelProperty(position=80, value="The Inbound Provisioning settings used to provision user accounts and groups.")
    public IdpInboundProvisioning getInboundProvisioning() {
        return this.inboundProvisioning;
    }

    public void setInboundProvisioning(IdpInboundProvisioning inboundProvisioning) {
        this.inboundProvisioning = inboundProvisioning;
    }
}

