/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model;

import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.admin.api.model.AttributeMapping;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description="The IdP-to-SP Adapter Mapping.")
public class IdpToSpAdapterMapping
extends AttributeMapping {
    private String id;
    private String sourceId;
    private String targetId;
    private String defaultTargetResource;
    private String licenseConnectionGroupAssignment;
    private String applicationName;
    private String applicationIconUrl;

    @ApiModelProperty(position=40, value="The id of the IdP Adapter.", required=true)
    public String getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    @ApiModelProperty(position=50, value="The id of the SP Adapter.", required=true)
    public String getTargetId() {
        return this.targetId;
    }

    public void setTargetId(String targetId) {
        this.targetId = targetId;
    }

    @ApiModelProperty(position=60, value="The id of the IdP-to-SP Adapter mapping. This field is read-only and is ignored when passed in with the payload.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setId(String sourceId, String targetId) {
        this.id = ApiUtil.combineId(sourceId, targetId);
    }

    @ApiModelProperty(position=70, value="Default target URL for this adapter-to-adapter mapping configuration.", required=false)
    public String getDefaultTargetResource() {
        return this.defaultTargetResource;
    }

    public void setDefaultTargetResource(String defaultTargetResource) {
        this.defaultTargetResource = defaultTargetResource;
    }

    @ApiModelProperty(position=80, value="The license connection group.")
    public String getLicenseConnectionGroupAssignment() {
        return this.licenseConnectionGroupAssignment;
    }

    public void setLicenseConnectionGroupAssignment(String licenseConnectionGroupAssignment) {
        this.licenseConnectionGroupAssignment = licenseConnectionGroupAssignment;
    }

    @ApiModelProperty(position=90, value="The application name.")
    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    @ApiModelProperty(position=100, value="The application icon URL.")
    public String getApplicationIconUrl() {
        return this.applicationIconUrl;
    }

    public void setApplicationIconUrl(String applicationIconUrl) {
        this.applicationIconUrl = applicationIconUrl;
    }
}

