/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.pingidentity.admin.api.model.ConditionalIssuanceCriteriaEntry;
import com.pingidentity.admin.api.model.ExpressionIssuanceCriteriaEntry;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.LinkedList;
import java.util.List;

@ApiModel(description="A list of criteria that determines whether a transaction (usually a SSO transaction) is continued. All criteria must pass in order for the transaction to continue.")
public class IssuanceCriteria {
    private List<ConditionalIssuanceCriteriaEntry> conditionalCriteria = new LinkedList<ConditionalIssuanceCriteriaEntry>();
    private List<ExpressionIssuanceCriteriaEntry> expressionCriteria = null;

    @ApiModelProperty(value="A list of conditional issuance criteria where existing attributes must satisfy their conditions against expected values in order for the transaction to continue.", position=10)
    public List<ConditionalIssuanceCriteriaEntry> getConditionalCriteria() {
        return this.conditionalCriteria;
    }

    public void setConditionalCriteria(List<ConditionalIssuanceCriteriaEntry> conditionalCriteria) {
        this.conditionalCriteria = conditionalCriteria == null ? new LinkedList<ConditionalIssuanceCriteriaEntry>() : conditionalCriteria;
    }

    @ApiModelProperty(value="A list of expression issuance criteria where the OGNL expressions must evaluate to true in order for the transaction to continue.", position=20)
    public List<ExpressionIssuanceCriteriaEntry> getExpressionCriteria() {
        return this.expressionCriteria;
    }

    public void setExpressionCriteria(List<ExpressionIssuanceCriteriaEntry> expressionCriteria) {
        this.expressionCriteria = expressionCriteria;
    }

    @JsonIgnore
    public boolean hasIssuanceCriteria() {
        return !this.conditionalCriteria.isEmpty() || this.expressionCriteria != null && !this.expressionCriteria.isEmpty();
    }
}

