/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model;

import com.pingidentity.admin.api.model.AttributeSource;
import com.pingidentity.admin.api.model.DataStoreType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;

@ApiModel(description="The configured settings used to look up attributes from a JDBC data store.", parent=AttributeSource.class)
public class JdbcAttributeSource
extends AttributeSource {
    private String schema;
    private String table;
    private String filter;
    private List<String> columnNames;

    @Override
    @ApiModelProperty(position=10, value="The data store type of this attribute source.", required=true)
    public DataStoreType getType() {
        return DataStoreType.JDBC;
    }

    @ApiModelProperty(value="Lists the table structure that stores information within a database. Some databases, such as Oracle, require a schema for a JDBC query. Other databases, such as MySQL, do not require a schema.", position=30)
    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    @ApiModelProperty(value="The name of the database table. The name is used to construct the SQL query to retrieve data from the data store.", position=40, required=true)
    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    @ApiModelProperty(value="A list of column names used to construct the SQL query to retrieve data from the specified table in the datastore.", position=50)
    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(List<String> columnNames) {
        this.columnNames = columnNames;
    }

    @ApiModelProperty(value="The JDBC WHERE clause used to query your data store to locate a user record.", position=60, required=true)
    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }
}

