/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model;

import com.pingidentity.admin.api.model.KerberosKeySet;
import com.pingidentity.admin.api.model.ResourceLink;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import org.sourceid.saml20.domain.KerberosConnectionType;

public class KerberosRealm {
    private String id;
    private String kerberosRealmName;
    private List<String> keyDistributionCenters;
    private String kerberosUsername;
    private String kerberosPassword;
    private String kerberosEncryptedPassword;
    private Boolean retainPreviousKeysOnPasswordChange;
    private Boolean suppressDomainNameConcatenation;
    private List<KerberosKeySet> keySets;
    private KerberosConnectionType connectionType = KerberosConnectionType.DIRECT;
    private ResourceLink ldapGatewayDataStoreRef;

    @ApiModelProperty(position=10, value="The persistent, unique ID for the Kerberos Realm. It can be any combination of [a-zA-Z0-9._-]. This property is system-assigned if not specified.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @ApiModelProperty(position=20, value="The Domain/Realm name used for display in UI screens.", required=true)
    public String getKerberosRealmName() {
        return this.kerberosRealmName;
    }

    public void setKerberosRealmName(String kerberosRealmName) {
        this.kerberosRealmName = kerberosRealmName;
    }

    @ApiModelProperty(position=25, value="Controls how PingFederate connects to the Active Directory/Kerberos Realm. The default is: \"DIRECT\".")
    public KerberosConnectionType getConnectionType() {
        return this.connectionType;
    }

    public void setConnectionType(KerberosConnectionType connectionType) {
        this.connectionType = connectionType;
    }

    @ApiModelProperty(position=30, value="The Domain Controller/Key Distribution Center Host Action Names. Only applicable when 'connectionType' is \"DIRECT\".")
    public List<String> getKeyDistributionCenters() {
        return this.keyDistributionCenters;
    }

    public void setKeyDistributionCenters(List<String> keyDistributionCenters) {
        this.keyDistributionCenters = keyDistributionCenters;
    }

    @ApiModelProperty(position=40, value="The Domain/Realm username. Only required when 'connectionType' is \"DIRECT\" or \"LOCAL_VALIDATION\".")
    public String getKerberosUsername() {
        return this.kerberosUsername;
    }

    public void setKerberosUsername(String kerberosUsername) {
        this.kerberosUsername = kerberosUsername;
    }

    @ApiModelProperty(position=50, value="The Domain/Realm password. GETs will not return this attribute. To update this field, specify the new value in this attribute. Only applicable when 'connectionType' is \"DIRECT\" or \"LOCAL_VALIDATION\".")
    public String getKerberosPassword() {
        return this.kerberosPassword;
    }

    public void setKerberosPassword(String kerberosPassword) {
        this.kerberosPassword = kerberosPassword;
    }

    @ApiModelProperty(position=60, value="For GET requests, this field contains the encrypted Domain/Realm password, if one exists. For POST and PUT requests, if you wish to reuse the existing password, this field should be passed back unchanged. Only applicable when 'connectionType' is \"DIRECT\" or \"LOCAL_VALIDATION\".")
    public String getKerberosEncryptedPassword() {
        return this.kerberosEncryptedPassword;
    }

    public void setKerberosEncryptedPassword(String kerberosEncryptedPassword) {
        this.kerberosEncryptedPassword = kerberosEncryptedPassword;
    }

    @ApiModelProperty(position=70, value="A list of key sets for validating Kerberos tickets. On POST or PUT, if 'retainPreviousKeysOnPasswordChange' is true, PingFederate automatically adds the key set for the current password to this list and removes expired key sets. If 'retainPreviousKeysOnPasswordChange' is false, this list is cleared. Only applicable when 'connectionType' is \"DIRECT\" or \"LOCAL_VALIDATION\".")
    public List<KerberosKeySet> getKeySets() {
        return this.keySets;
    }

    public void setKeySets(List<KerberosKeySet> keySets) {
        this.keySets = keySets;
    }

    @ApiModelProperty(position=80, value="Determines whether the previous encryption keys are retained when the password is updated. Retaining the previous keys allows existing Kerberos tickets to continue to be validated. The default is false. Only applicable when 'connectionType' is \"DIRECT\" or \"LOCAL_VALIDATION\".")
    public Boolean isRetainPreviousKeysOnPasswordChange() {
        return this.retainPreviousKeysOnPasswordChange;
    }

    public void setRetainPreviousKeysOnPasswordChange(Boolean retainPreviousKeysOnPasswordChange) {
        this.retainPreviousKeysOnPasswordChange = retainPreviousKeysOnPasswordChange;
    }

    @ApiModelProperty(position=90, value="Controls whether the KDC hostnames and the realm name are concatenated in the auto-generated krb5.conf file. Default is false. Only applicable when 'connectionType' is \"DIRECT\".")
    public Boolean getSuppressDomainNameConcatenation() {
        return this.suppressDomainNameConcatenation;
    }

    public void setSuppressDomainNameConcatenation(Boolean suppressDomainNameConcatenation) {
        this.suppressDomainNameConcatenation = suppressDomainNameConcatenation;
    }

    @ApiModelProperty(position=100, value="The LDAP gateway used by PingFederate to communicate with the Active Directory. Only required when 'connectionType' is \"LDAP_GATEWAY\".")
    public ResourceLink getLdapGatewayDataStoreRef() {
        return this.ldapGatewayDataStoreRef;
    }

    public void setLdapGatewayDataStoreRef(ResourceLink ldapGatewayDataStoreRef) {
        this.ldapGatewayDataStoreRef = ldapGatewayDataStoreRef;
    }
}

