/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model;

import com.pingidentity.admin.api.model.CryptoProvider;
import com.pingidentity.crypto.KeyPairFileFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description="Represents the contents of a PKCS12 or PEM file.")
public class KeyPairFile {
    private String id;
    private String fileData;
    private KeyPairFileFormat format;
    private String password;
    private String encryptedPassword;
    private CryptoProvider cryptoProvider;

    @ApiModelProperty(position=10, value="The persistent, unique ID for the certificate. It can be any combination of [a-zA-Z0-9._-]. This property is system-assigned if not specified.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @ApiModelProperty(position=20, required=true, value="Base-64 encoded PKCS12 or PEM file data. In the case of PEM, the raw (non-base-64) data is also accepted. In BCFIPS mode, only PEM with PBES2 and AES or Triple DES encryption is accepted and 128-bit salt is required.")
    public String getFileData() {
        return this.fileData;
    }

    public void setFileData(String fileData) {
        this.fileData = fileData;
    }

    @ApiModelProperty(position=30, value="Key pair file format. If specified, this field will control what file format is expected, otherwise the format will be auto-detected. In BCFIPS mode, only PEM is supported.")
    public KeyPairFileFormat getFormat() {
        return this.format;
    }

    public void setFormat(KeyPairFileFormat format) {
        this.format = format;
    }

    @ApiModelProperty(position=40, required=true, value="Password for the file. In BCFIPS mode, the password must be at least 14 characters.")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @ApiModelProperty(position=50, value="Encrypted password for the file. Only applicable for bulk export/import operations. For bulk import operation, either password or encrypted password must be set.")
    public String getEncryptedPassword() {
        return this.encryptedPassword;
    }

    public void setEncryptedPassword(String encryptedPassword) {
        this.encryptedPassword = encryptedPassword;
    }

    @ApiModelProperty(position=60, value="Cryptographic Provider. This is only applicable if Hybrid HSM mode is true.")
    public CryptoProvider getCryptoProvider() {
        return this.cryptoProvider;
    }

    public void setCryptoProvider(CryptoProvider cryptoProvider) {
        this.cryptoProvider = cryptoProvider;
    }

    public static class Builder {
        private final String id;
        private KeyPairFileFormat format;
        private String fileData;
        private String password;
        private String encryptedPassword;
        private CryptoProvider cryptoProvider;

        public Builder(String id) {
            this.id = id;
        }

        public Builder keyPairFileFormat(KeyPairFileFormat keyPairFileFormat) {
            this.format = keyPairFileFormat;
            return this;
        }

        public Builder fileData(String fileData) {
            this.fileData = fileData;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder encryptedPassword(String encryptedPassword) {
            this.encryptedPassword = encryptedPassword;
            return this;
        }

        public Builder cryptoProvider(CryptoProvider cryptoProvider) {
            this.cryptoProvider = cryptoProvider;
            return this;
        }

        public KeyPairFile build() {
            KeyPairFile file = new KeyPairFile();
            file.id = this.id;
            file.fileData = this.fileData;
            file.format = this.format;
            file.password = this.password;
            file.encryptedPassword = this.encryptedPassword;
            file.cryptoProvider = this.cryptoProvider;
            return file;
        }
    }
}

