/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model;

import com.pingidentity.admin.api.model.AttributeSource;
import com.pingidentity.admin.api.model.BinaryLdapAttributeSettings;
import com.pingidentity.admin.api.model.DataStoreType;
import com.pingidentity.admin.api.model.LdapSearchScope;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@ApiModel(description="The configured settings used to look up attributes from a LDAP data store.", parent=AttributeSource.class)
public class LdapAttributeSource
extends AttributeSource {
    private String baseDn;
    private LdapSearchScope searchScope;
    private String searchFilter;
    private List<String> searchAttributes;
    private Map<String, BinaryLdapAttributeSettings> binaryAttributeSettings = new HashMap<String, BinaryLdapAttributeSettings>();
    private boolean memberOfNestedGroup;

    @Override
    @ApiModelProperty(position=10, value="The data store type of this attribute source.", required=true)
    public DataStoreType getType() {
        return DataStoreType.LDAP;
    }

    @ApiModelProperty(value="The base DN to search from. If not specified, the search will start at the LDAP's root.", position=30)
    public String getBaseDn() {
        return this.baseDn;
    }

    public void setBaseDn(String baseDn) {
        this.baseDn = baseDn;
    }

    @ApiModelProperty(value="Determines the node depth of the query.", position=40, required=true)
    public LdapSearchScope getSearchScope() {
        return this.searchScope;
    }

    public void setSearchScope(LdapSearchScope searchScope) {
        this.searchScope = searchScope;
    }

    @ApiModelProperty(value="The LDAP filter that will be used to lookup the objects from the directory.", position=50, required=true)
    public String getSearchFilter() {
        return this.searchFilter;
    }

    public void setSearchFilter(String searchFilter) {
        this.searchFilter = searchFilter;
    }

    @ApiModelProperty(value="A list of LDAP attributes returned from search and available for mapping.", position=55)
    public List<String> getSearchAttributes() {
        return this.searchAttributes;
    }

    public void setSearchAttributes(List<String> searchAttributes) {
        this.searchAttributes = searchAttributes;
    }

    @ApiModelProperty(value="The advanced settings for binary LDAP attributes.", position=60)
    public Map<String, BinaryLdapAttributeSettings> getBinaryAttributeSettings() {
        return this.binaryAttributeSettings;
    }

    public void setBinaryAttributeSettings(Map<String, BinaryLdapAttributeSettings> binaryAttributeSettings) {
        this.binaryAttributeSettings = binaryAttributeSettings == null ? new HashMap<String, BinaryLdapAttributeSettings>() : binaryAttributeSettings;
    }

    @ApiModelProperty(value="Set this to true to return transitive group memberships for the 'memberOf' attribute.  This only applies for Active Directory data sources.  All other data sources will be set to false.", position=70)
    public boolean isMemberOfNestedGroup() {
        return this.memberOfNestedGroup;
    }

    public void setMemberOfNestedGroup(boolean memberOfNestedGroup) {
        this.memberOfNestedGroup = memberOfNestedGroup;
    }
}

