/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model;

import com.pingidentity.admin.api.model.DataStore;
import com.pingidentity.admin.api.model.DataStoreType;
import com.pingidentity.admin.api.model.LdapType;
import com.pingidentity.admin.api.model.ResourceLink;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.sourceid.saml20.domain.datasource.tag.LdapTagConfig;

@ApiModel(description="A LDAP data store.", parent=DataStore.class)
public class LdapDataStore
implements DataStore {
    private String id;
    private boolean maskAttributeValues;
    private List<String> hostnames = new ArrayList<String>();
    private LdapType ldapType = LdapType.GENERIC;
    private boolean bindAnonymously = false;
    private String userDN;
    private String password;
    private String encryptedPassword;
    private ResourceLink clientTlsCertificateRef;
    private boolean useSsl;
    private boolean useDnsSrvRecords;
    private Boolean followLDAPReferrals;
    private String name;
    private List<LdapTagConfig> hostnamesTags;
    private Date lastModified;
    private boolean retryFailedOperations = false;
    private boolean testOnBorrow;
    private boolean testOnReturn;
    private boolean createIfNecessary = true;
    private boolean verifyHost = true;
    private Integer minConnections;
    private Integer maxConnections;
    private Integer maxWait;
    private Integer timeBetweenEvictions;
    private Integer readTimeout;
    private Integer connectionTimeout;
    private List<String> binaryAttributes;
    private Integer dnsTtl;
    private String ldapDnsSrvPrefix;
    private String ldapsDnsSrvPrefix;
    private boolean useStartTLS;

    @Override
    @ApiModelProperty(position=10, value="The data store type.", required=true)
    public DataStoreType getType() {
        return DataStoreType.LDAP;
    }

    @Override
    @ApiModelProperty(position=20, value="The persistent, unique ID for the data store. It can be any combination of [a-zA-Z0-9._-]. This property is system-assigned if not specified.")
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    @ApiModelProperty(position=30, value="Whether attribute values should be masked in the log.")
    public boolean isMaskAttributeValues() {
        return this.maskAttributeValues;
    }

    @Override
    public void setMaskAttributeValues(boolean maskAttributeValues) {
        this.maskAttributeValues = maskAttributeValues;
    }

    @ApiModelProperty(position=40, value="The set of host names and associated tags for this LDAP data store. This is required if 'hostnames' is not provided.")
    public List<LdapTagConfig> getHostnamesTags() {
        return this.hostnamesTags;
    }

    public void setHostnamesTags(List<LdapTagConfig> hostnamesTags) {
        this.hostnamesTags = hostnamesTags;
    }

    @ApiModelProperty(position=42, value="The default LDAP host names. This field is required if no mapping for host names and tags is specified. Failover can be configured by providing multiple host names.")
    public List<String> getHostnames() {
        return this.hostnames;
    }

    public void setHostnames(List<String> hostnames) {
        this.hostnames = hostnames;
    }

    @ApiModelProperty(position=45, value="The data store name with a unique value across all data sources. Omitting this attribute will set the value to a combination of the hostname(s) and the principal.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(position=50, value="A type that allows PingFederate to configure many provisioning settings automatically. The 'UNBOUNDID_DS' type has been deprecated, please use the 'PING_DIRECTORY' type instead.", required=true)
    public LdapType getLdapType() {
        return this.ldapType;
    }

    public void setLdapType(LdapType ldapType) {
        this.ldapType = ldapType;
    }

    @ApiModelProperty(position=60, value="Whether username and password are required. If true, no other authentication fields should be provided. The default value is false.")
    public boolean isBindAnonymously() {
        return this.bindAnonymously;
    }

    public void setBindAnonymously(boolean bindAnonymously) {
        this.bindAnonymously = bindAnonymously;
    }

    @ApiModelProperty(position=70, value="The username credential required to access the data store. If specified, no other authentication fields should be provided.")
    public String getUserDN() {
        return this.userDN;
    }

    public void setUserDN(String userDN) {
        this.userDN = userDN;
    }

    @ApiModelProperty(position=80, value="The password credential required to access the data store. GETs will not return this attribute. To update this field, specify the new value in this attribute.")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @ApiModelProperty(position=90, value="The encrypted password credential required to access the data store.  If you do not want to update the stored value, this attribute should be passed back unchanged. Secret Reference may be provided in this field with format 'OBF:MGR:{secretManagerId}:{secretId}'.")
    public String getEncryptedPassword() {
        return this.encryptedPassword;
    }

    public void setEncryptedPassword(String encryptedPassword) {
        this.encryptedPassword = encryptedPassword;
    }

    @ApiModelProperty(position=91, value="The client TLS certificate used to access the data store. If specified, authentication to the data store will be done using mutual TLS and no other authentication fields should be provided. See '/keyPairs/sslClient' to manage certificates.")
    public ResourceLink getClientTlsCertificateRef() {
        return this.clientTlsCertificateRef;
    }

    public void setClientTlsCertificateRef(ResourceLink clientTlsCertificateRef) {
        this.clientTlsCertificateRef = clientTlsCertificateRef;
    }

    @ApiModelProperty(position=100, value="Connects to the LDAP data store using secure SSL/TLS encryption (LDAPS). The default value is false.")
    public boolean isUseSsl() {
        return this.useSsl;
    }

    public void setUseSsl(boolean useSsl) {
        this.useSsl = useSsl;
    }

    @ApiModelProperty(position=101, value="Use DNS SRV Records to discover LDAP server information. The default value is false.")
    public boolean isUseDnsSrvRecords() {
        return this.useDnsSrvRecords;
    }

    public void setUseDnsSrvRecords(boolean useDnsSrvRecords) {
        this.useDnsSrvRecords = useDnsSrvRecords;
    }

    @ApiModelProperty(position=102, value="Follow LDAP Referrals in the domain tree. The default value is false. This property does not apply to PingDirectory as this functionality is configured in PingDirectory.")
    public Boolean isFollowLDAPReferrals() {
        return this.followLDAPReferrals;
    }

    public void setFollowLDAPReferrals(Boolean followLDAPReferrals) {
        this.followLDAPReferrals = followLDAPReferrals;
    }

    @ApiModelProperty(position=103, value="Connects to the LDAP data store using secure StartTLS encryption. The default value is false.")
    public boolean isUseStartTLS() {
        return this.useStartTLS;
    }

    public void setUseStartTLS(boolean useStartTLS) {
        this.useStartTLS = useStartTLS;
    }

    @ApiModelProperty(position=105, value="Indicates whether failed operations should be retried. The default is false.")
    public boolean isRetryFailedOperations() {
        return this.retryFailedOperations;
    }

    public void setRetryFailedOperations(boolean doRetries) {
        this.retryFailedOperations = doRetries;
    }

    @ApiModelProperty(position=110, value="Indicates whether objects are validated before being borrowed from the pool.")
    public boolean isTestOnBorrow() {
        return this.testOnBorrow;
    }

    public void setTestOnBorrow(boolean testOnBorrow) {
        this.testOnBorrow = testOnBorrow;
    }

    @ApiModelProperty(position=120, value="Indicates whether objects are validated before being returned to the pool.")
    public boolean isTestOnReturn() {
        return this.testOnReturn;
    }

    public void setTestOnReturn(boolean testOnReturn) {
        this.testOnReturn = testOnReturn;
    }

    @ApiModelProperty(position=130, value="Indicates whether temporary connections can be created when the Maximum Connections threshold is reached.")
    public boolean isCreateIfNecessary() {
        return this.createIfNecessary;
    }

    public void setCreateIfNecessary(boolean createIfNecessary) {
        this.createIfNecessary = createIfNecessary;
    }

    @ApiModelProperty(position=131, value="Verifies that the presented server certificate includes the address to which the client intended to establish a connection. Omitting this attribute will set the value to true.")
    public boolean isVerifyHost() {
        return this.verifyHost;
    }

    public void setVerifyHost(boolean verifyHost) {
        this.verifyHost = verifyHost;
    }

    @ApiModelProperty(position=140, value="The smallest number of connections that can remain in each pool, without creating extra ones. Omitting this attribute will set the value to the default value.")
    public Integer getMinConnections() {
        return this.minConnections;
    }

    public void setMinConnections(Integer minConnections) {
        this.minConnections = minConnections;
    }

    @ApiModelProperty(position=150, value="The largest number of active connections that can remain in each pool without releasing extra ones. Omitting this attribute will set the value to the default value.")
    public Integer getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(Integer maxConnections) {
        this.maxConnections = maxConnections;
    }

    @ApiModelProperty(position=160, value="The maximum number of milliseconds the pool waits for a connection to become available when trying to obtain a connection from the pool. Omitting this attribute or setting a value of -1 causes the pool not to wait at all and to either create a new connection or produce an error (when no connections are available).")
    public Integer getMaxWait() {
        return this.maxWait;
    }

    public void setMaxWait(Integer maxWait) {
        this.maxWait = maxWait;
    }

    @ApiModelProperty(position=170, value="The frequency, in milliseconds, that the evictor cleans up the connections in the pool. A value of -1 disables the evictor. Omitting this attribute will set the value to the default value.")
    public Integer getTimeBetweenEvictions() {
        return this.timeBetweenEvictions;
    }

    public void setTimeBetweenEvictions(Integer timeBetweenEvictions) {
        this.timeBetweenEvictions = timeBetweenEvictions;
    }

    @ApiModelProperty(position=180, value="The maximum number of milliseconds a connection waits for a response to be returned before producing an error. A value of -1 causes the connection to wait indefinitely. Omitting this attribute will set the value to the default value.")
    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
    }

    @ApiModelProperty(position=190, value="The maximum number of milliseconds that a connection attempt should be allowed to continue before returning an error. A value of -1 causes the pool to wait indefinitely. Omitting this attribute will set the value to the default value.")
    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    @ApiModelProperty(position=191, value="The maximum time in milliseconds that DNS information are cached. Omitting this attribute will set the value to the default value.")
    public Integer getDnsTtl() {
        return this.dnsTtl;
    }

    public void setDnsTtl(Integer dnsTtl) {
        this.dnsTtl = dnsTtl;
    }

    @ApiModelProperty(position=192, value="The prefix value used to discover LDAP DNS SRV record. Omitting this attribute will set the value to the default value.")
    public String getLdapDnsSrvPrefix() {
        return this.ldapDnsSrvPrefix;
    }

    public void setLdapDnsSrvPrefix(String ldapDnsSrvPrefix) {
        this.ldapDnsSrvPrefix = ldapDnsSrvPrefix;
    }

    @ApiModelProperty(position=193, value="The prefix value used to discover LDAPs DNS SRV record. Omitting this attribute will set the value to the default value.")
    public String getLdapsDnsSrvPrefix() {
        return this.ldapsDnsSrvPrefix;
    }

    public void setLdapsDnsSrvPrefix(String ldapsDnsSrvPrefix) {
        this.ldapsDnsSrvPrefix = ldapsDnsSrvPrefix;
    }

    @ApiModelProperty(position=200, value="The list of LDAP attributes to be handled as binary data.")
    public List<String> getBinaryAttributes() {
        return this.binaryAttributes;
    }

    public void setBinaryAttributes(List<String> binaryAttributes) {
        this.binaryAttributes = binaryAttributes;
    }

    @Override
    @ApiModelProperty(position=210, value="The time at which the datastore instance was last changed. This property is read only and is ignored on PUT and POST requests.")
    public Date getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return new Date(this.lastModified.getTime());
    }

    @Override
    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified == null ? null : new Date(lastModified.getTime());
    }
}

