/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model;

import com.pingidentity.admin.api.model.JwtSecuredAuthorizationResponseModeType;
import com.pingidentity.admin.api.model.OIDCAuthenticationScheme;
import com.pingidentity.admin.api.model.OIDCLoginType;
import com.pingidentity.admin.api.model.OIDCRequestParameter;
import com.pingidentity.admin.api.model.oauth.SigningAlgorithm;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;

@ApiModel(description="The OpenID Provider settings.")
public class OIDCProviderSettings {
    private String scopes;
    private String authorizationEndpoint;
    private OIDCLoginType loginType;
    private JwtSecuredAuthorizationResponseModeType jwtSecuredAuthorizationResponseModeType;
    private OIDCAuthenticationScheme authenticationScheme;
    private String type;
    private String lifetime;
    private String audience;
    private boolean includeNotBeforeClaim;
    private boolean enablePKCE;
    private String tokenEndpoint;
    private String userInfoEndpoint;
    private String logoutEndpoint;
    private String jwksURL;
    private SigningAlgorithm authenticationSigningAlgorithm;
    private List<OIDCRequestParameter> requestParameters = null;
    private SigningAlgorithm requestSigningAlgorithm;
    private boolean trackUserSessionsForLogout = false;
    private String redirectUri;
    private String backChannelLogoutUri;
    private String frontChannelLogoutUri;
    private String postLogoutRedirectUri;
    private String pushedAuthorizationRequestEndpoint;

    @ApiModelProperty(position=100, value="Space separated scope values that the OpenID Provider supports.", required=true)
    public String getScopes() {
        return this.scopes;
    }

    public void setScopes(String scopes) {
        this.scopes = scopes;
    }

    @ApiModelProperty(position=110, value="URL of the OpenID Provider's OAuth 2.0 Authorization Endpoint.", required=true)
    public String getAuthorizationEndpoint() {
        return this.authorizationEndpoint;
    }

    public void setAuthorizationEndpoint(String authorizationEndpoint) {
        this.authorizationEndpoint = authorizationEndpoint;
    }

    @ApiModelProperty(position=115, value="URL of the OpenID Provider's OAuth 2.0 Pushed Authorization Request Endpoint.", required=false)
    public String getPushedAuthorizationRequestEndpoint() {
        return this.pushedAuthorizationRequestEndpoint;
    }

    public void setPushedAuthorizationRequestEndpoint(String pushedAuthorizationRequestEndpoint) {
        this.pushedAuthorizationRequestEndpoint = pushedAuthorizationRequestEndpoint;
    }

    @ApiModelProperty(position=120, value="The OpenID Connect login type. These values maps to: <br>  CODE: Authentication using Code Flow <br> POST: Authentication using Form Post <br> POST_AT: Authentication using Form Post with Access Token", required=true)
    public OIDCLoginType getLoginType() {
        return this.loginType;
    }

    public void setLoginType(OIDCLoginType loginType) {
        this.loginType = loginType;
    }

    @ApiModelProperty(position=125, value="The OpenId Connect JWT Secured Authorization Response Mode (JARM). These values map to: <br>  DISABLED: Authorization responses will not be encoded using JARM. This is the default value. <br>  QUERY_JWT: query.jwt <br> FORM_POST_JWT: form_post.jwt <br><br> Note: QUERY_JWT must not be used in conjunction with loginType POST or  POST_AT unless the response JWT is encrypted to prevent token leakage in the URL.")
    public JwtSecuredAuthorizationResponseModeType getJwtSecuredAuthorizationResponseModeType() {
        return this.jwtSecuredAuthorizationResponseModeType;
    }

    public void setJwtSecuredAuthorizationResponseModeType(JwtSecuredAuthorizationResponseModeType jwtSecuredAuthorizationResponseModeType) {
        this.jwtSecuredAuthorizationResponseModeType = jwtSecuredAuthorizationResponseModeType;
    }

    @ApiModelProperty(position=130, value="The OpenID Connect Authentication Scheme. This is required for Authentication using Code Flow. ")
    public OIDCAuthenticationScheme getAuthenticationScheme() {
        return this.authenticationScheme;
    }

    public void setAuthenticationScheme(OIDCAuthenticationScheme authenticationScheme) {
        this.authenticationScheme = authenticationScheme;
    }

    @ApiModelProperty(position=140, value="The header `typ`, that goes into the JWT header if specified. This is only used for client secret jwt and private key jwt auth schemes.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @ApiModelProperty(position=150, value="The lifetime of the JWT in minutes. This is only used for client secret jwt and private key jwt auth schemes.")
    public String getLifetime() {
        return this.lifetime;
    }

    public void setLifetime(String lifetime) {
        this.lifetime = lifetime;
    }

    @ApiModelProperty(position=160, value="The claim `aud`, that goes into the JWT body if specified. This is only used for client secret jwt and private key jwt auth schemes.")
    public String getAudience() {
        return this.audience;
    }

    public void setAudience(String audience) {
        this.audience = audience;
    }

    @ApiModelProperty(position=170, value="Include the claim `nbf` in the JWT body. This is only used for client secret jwt and private key jwt auth schemes.")
    public boolean isIncludeNotBeforeClaim() {
        return this.includeNotBeforeClaim;
    }

    public void setIncludeNotBeforeClaim(boolean includeNotBeforeClaim) {
        this.includeNotBeforeClaim = includeNotBeforeClaim;
    }

    @ApiModelProperty(position=180, value="The authentication signing algorithm for token endpoint PRIVATE_KEY_JWT or CLIENT_SECRET_JWT authentication. Asymmetric algorithms are allowed for PRIVATE_KEY_JWT and symmetric algorithms are allowed for CLIENT_SECRET_JWT. For RSASSA-PSS signing algorithm, PingFederate must be integrated with a hardware security module (HSM) or Java 11.")
    public SigningAlgorithm getAuthenticationSigningAlgorithm() {
        return this.authenticationSigningAlgorithm;
    }

    public void setAuthenticationSigningAlgorithm(SigningAlgorithm authenticationSigningAlgorithm) {
        this.authenticationSigningAlgorithm = authenticationSigningAlgorithm;
    }

    @ApiModelProperty(position=190, value="The request signing algorithm. Required only if you wish to use signed requests. Only asymmetric algorithms are allowed. For RSASSA-PSS signing algorithm, PingFederate must be integrated with a hardware security module (HSM) or Java 11.")
    public SigningAlgorithm getRequestSigningAlgorithm() {
        return this.requestSigningAlgorithm;
    }

    public void setRequestSigningAlgorithm(SigningAlgorithm requestSigningAlgorithm) {
        this.requestSigningAlgorithm = requestSigningAlgorithm;
    }

    @ApiModelProperty(position=195, value="Enable Proof Key for Code Exchange (PKCE). When enabled, the client sends an SHA-256 code challenge and corresponding code verifier to the OpenID Provider during the authorization code flow.")
    public boolean getEnablePKCE() {
        return this.enablePKCE;
    }

    public void setEnablePKCE(boolean enablePKCE) {
        this.enablePKCE = enablePKCE;
    }

    @ApiModelProperty(position=200, value="URL of the OpenID Provider's OAuth 2.0 Token Endpoint.")
    public String getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    public void setTokenEndpoint(String tokenEndpoint) {
        this.tokenEndpoint = tokenEndpoint;
    }

    @ApiModelProperty(position=210, value="URL of the OpenID Provider's UserInfo Endpoint.")
    public String getUserInfoEndpoint() {
        return this.userInfoEndpoint;
    }

    public void setUserInfoEndpoint(String userInfoEndpoint) {
        this.userInfoEndpoint = userInfoEndpoint;
    }

    @ApiModelProperty(position=215, value="URL of the OpenID Provider's RP-Initiated Logout Endpoint.")
    public String getLogoutEndpoint() {
        return this.logoutEndpoint;
    }

    public void setLogoutEndpoint(String logoutEndpoint) {
        this.logoutEndpoint = logoutEndpoint;
    }

    @ApiModelProperty(position=220, value="URL of the OpenID Provider's JSON Web Key Set [JWK] document.", required=true)
    public String getJwksURL() {
        return this.jwksURL;
    }

    public void setJwksURL(String jwksURL) {
        this.jwksURL = jwksURL;
    }

    @ApiModelProperty(position=225, value="Determines whether PingFederate tracks a logout entry when a user signs in, so that the user session can later be terminated via a logout request from the OP. This setting must also be enabled in order for PingFederate to send an RP-initiated logout request to the OP during SLO.")
    public boolean isTrackUserSessionsForLogout() {
        return this.trackUserSessionsForLogout;
    }

    public void setTrackUserSessionsForLogout(boolean trackUserSessionsForLogout) {
        this.trackUserSessionsForLogout = trackUserSessionsForLogout;
    }

    @ApiModelProperty(position=230, value="A list of request parameters. Request parameters with same name but different attribute values are treated as a multi-valued request parameter.")
    public List<OIDCRequestParameter> getRequestParameters() {
        return this.requestParameters;
    }

    public void setRequestParameters(List<OIDCRequestParameter> requestParameters) {
        this.requestParameters = requestParameters;
    }

    @ApiModelProperty(position=240, value="The redirect URI. This is a read-only parameter.")
    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    @ApiModelProperty(position=250, value="The Back-Channel Logout URI. This read-only parameter is available when user sessions are tracked for logout.")
    public String getBackChannelLogoutUri() {
        return this.backChannelLogoutUri;
    }

    public void setBackChannelLogoutUri(String backChannelLogoutUri) {
        this.backChannelLogoutUri = backChannelLogoutUri;
    }

    @ApiModelProperty(position=260, value="The Front-Channel Logout URI. This is a read-only parameter.")
    public String getFrontChannelLogoutUri() {
        return this.frontChannelLogoutUri;
    }

    public void setFrontChannelLogoutUri(String frontChannelLogoutUri) {
        this.frontChannelLogoutUri = frontChannelLogoutUri;
    }

    @ApiModelProperty(position=270, value="The Post-Logout Redirect URI, where the OpenID Provider may redirect the user when RP-Initiated Logout has completed. This is a read-only parameter.")
    public String getPostLogoutRedirectUri() {
        return this.postLogoutRedirectUri;
    }

    public void setPostLogoutRedirectUri(String postLogoutRedirectUri) {
        this.postLogoutRedirectUri = postLogoutRedirectUri;
    }
}

