/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model;

import com.pingidentity.admin.api.model.ResourceLink;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;

@ApiModel(description="PingOne for Enterprise Settings")
public class PingOneForEnterpriseSettings {
    private boolean connectedToPingOneForEnterprise = false;
    private boolean enableAdminConsoleSso = false;
    private boolean enableMonitoring = true;
    private String companyName;
    private ResourceLink pingOneSsoConnection;
    private Date currentAuthnKeyCreationTime;
    private Date previousAuthnKeyCreationTime;
    private boolean identityRepositoryUpdateRequired = false;

    @ApiModelProperty(position=10, value="A read only field indicating whether PingFederate is connected to PingOne for Enterprise.")
    public boolean getConnectedToPingOneForEnterprise() {
        return this.connectedToPingOneForEnterprise;
    }

    public void setConnectedToPingOneForEnterprise(boolean connectedToPingOneForEnterprise) {
        this.connectedToPingOneForEnterprise = connectedToPingOneForEnterprise;
    }

    @ApiModelProperty(position=20, value="A read only reference to the SP connection configured for PingOne SSO.")
    public ResourceLink getPingOneSsoConnection() {
        return this.pingOneSsoConnection;
    }

    public void setPingOneSsoConnection(ResourceLink pingOneSsoConnection) {
        this.pingOneSsoConnection = pingOneSsoConnection;
    }

    @ApiModelProperty(position=30, value="A read only field indicating the company name.")
    public String getCompanyName() {
        return this.companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    @ApiModelProperty(position=40, value="Indicates whether single sign on from PingOne for Enterprise to the PingFederate admin console is enabled. The default is false.")
    public boolean getEnableAdminConsoleSso() {
        return this.enableAdminConsoleSso;
    }

    public void setEnableAdminConsoleSso(boolean enableAdminConsoleSso) {
        this.enableAdminConsoleSso = enableAdminConsoleSso;
    }

    @ApiModelProperty(position=50, value="Indicates whether monitoring of PingFederate from PingOne for Enterprise is enabled. The default is true.")
    public boolean getEnableMonitoring() {
        return this.enableMonitoring;
    }

    public void setEnableMonitoring(boolean enableMonitoring) {
        this.enableMonitoring = enableMonitoring;
    }

    @ApiModelProperty(position=60, value="A read only field indicating the creation time of the current authentication key.")
    public Date getCurrentAuthnKeyCreationTime() {
        return this.currentAuthnKeyCreationTime == null ? null : new Date(this.currentAuthnKeyCreationTime.getTime());
    }

    public void setCurrentAuthnKeyCreationTime(Date currentAuthnKeyCreationTime) {
        this.currentAuthnKeyCreationTime = currentAuthnKeyCreationTime == null ? null : new Date(currentAuthnKeyCreationTime.getTime());
    }

    @ApiModelProperty(position=70, value="A read only field indicating the creation time of the previous authentication key.")
    public Date getPreviousAuthnKeyCreationTime() {
        return this.previousAuthnKeyCreationTime == null ? null : new Date(this.previousAuthnKeyCreationTime.getTime());
    }

    public void setPreviousAuthnKeyCreationTime(Date previousAuthnKeyCreationTime) {
        this.previousAuthnKeyCreationTime = previousAuthnKeyCreationTime == null ? null : new Date(previousAuthnKeyCreationTime.getTime());
    }

    @ApiModelProperty(position=80, value="A read-only field indicating whether changes were made in the current PingFederate configuration that might affect your connection with PingOne for Enterprise. For example, if you modified the attribute contract of your SSO configuration. Update the identity repository to keep your PingFederate and PingOne for Enterprise settings synchronized. ")
    public boolean getIdentityRepositoryUpdateRequired() {
        return this.identityRepositoryUpdateRequired;
    }

    public void setIdentityRepositoryUpdateRequired(boolean identityRepositoryUpdateRequired) {
        this.identityRepositoryUpdateRequired = identityRepositoryUpdateRequired;
    }
}

