/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model;

import com.pingidentity.admin.api.model.DataStore;
import com.pingidentity.admin.api.model.DataStoreType;
import com.pingidentity.admin.api.model.LdapType;
import com.pingidentity.admin.api.model.ResourceLink;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.List;

@ApiModel(description="A LDAP gateway data store.", parent=DataStore.class)
public class PingOneLdapGatewayDataStore
implements DataStore {
    private String id;
    private boolean maskAttributeValues;
    private LdapType ldapType = LdapType.GENERIC;
    private String name;
    private ResourceLink pingOneConnectionRef;
    private String pingOneEnvironmentId;
    private String pingOneLdapGatewayId;
    private List<String> binaryAttributes;
    private Boolean useSsl;
    private Boolean useStartTLS;
    private Date lastModified;

    @Override
    @ApiModelProperty(position=10, value="The data store type.", required=true)
    public DataStoreType getType() {
        return DataStoreType.PING_ONE_LDAP_GATEWAY;
    }

    @Override
    @ApiModelProperty(position=20, value="The persistent, unique ID for the data store. It can be any combination of [a-zA-Z0-9._-]. This property is system-assigned if not specified.")
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    @ApiModelProperty(position=30, value="Whether attribute values should be masked in the log.")
    public boolean isMaskAttributeValues() {
        return this.maskAttributeValues;
    }

    @Override
    public void setMaskAttributeValues(boolean maskAttributeValues) {
        this.maskAttributeValues = maskAttributeValues;
    }

    @ApiModelProperty(position=40, value="The data store name with a unique value across all data sources. Omitting this attribute will set the value to a combination of the hostname(s) and the principal.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(position=50, value="A type that allows PingFederate to configure many provisioning settings automatically. The value is validated against the LDAP gateway configuration in PingOne unless the header 'X-BypassExternalValidation' is set to true.", required=true)
    public LdapType getLdapType() {
        return this.ldapType;
    }

    public void setLdapType(LdapType ldapType) {
        this.ldapType = ldapType;
    }

    @ApiModelProperty(position=60, value="Reference to the PingOne connection this gateway uses.", required=true)
    public ResourceLink getPingOneConnectionRef() {
        return this.pingOneConnectionRef;
    }

    public void setPingOneConnectionRef(ResourceLink pingOneConnectionRef) {
        this.pingOneConnectionRef = pingOneConnectionRef;
    }

    @ApiModelProperty(position=70, value="The environment ID that the gateway belongs to.", required=true)
    public String getPingOneEnvironmentId() {
        return this.pingOneEnvironmentId;
    }

    public void setPingOneEnvironmentId(String pingOneEnvironmentId) {
        this.pingOneEnvironmentId = pingOneEnvironmentId;
    }

    @ApiModelProperty(position=80, value="The ID of the PingOne LDAP Gateway this data store uses.", required=true)
    public String getPingOneLdapGatewayId() {
        return this.pingOneLdapGatewayId;
    }

    public void setPingOneLdapGatewayId(String pingOneLdapGatewayId) {
        this.pingOneLdapGatewayId = pingOneLdapGatewayId;
    }

    @ApiModelProperty(position=100, value="Connects to the LDAP data store using secure SSL/TLS encryption (LDAPS). The default value is false. The value is validated against the LDAP gateway configuration in PingOne unless the header 'X-BypassExternalValidation' is set to true.")
    public Boolean isUseSsl() {
        return this.useSsl;
    }

    public void setUseSsl(Boolean useSsl) {
        this.useSsl = useSsl;
    }

    @ApiModelProperty(position=110, value="Connects to the LDAP data store using StartTLS. The default value is false. The value is validated against the LDAP gateway configuration in PingOne unless the header 'X-BypassExternalValidation' is set to true.")
    public Boolean isUseStartTLS() {
        return this.useStartTLS;
    }

    public void setUseStartTLS(Boolean useStartTLS) {
        this.useStartTLS = useStartTLS;
    }

    @ApiModelProperty(position=200, value="The list of LDAP attributes to be handled as binary data.")
    public List<String> getBinaryAttributes() {
        return this.binaryAttributes;
    }

    public void setBinaryAttributes(List<String> binaryAttributes) {
        this.binaryAttributes = binaryAttributes;
    }

    @Override
    @ApiModelProperty(position=210, value="The time at which the datastore instance was last changed. This property is read only and is ignored on PUT and POST requests.")
    public Date getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return new Date(this.lastModified.getTime());
    }

    @Override
    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified == null ? null : new Date(lastModified.getTime());
    }
}

