/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model;

import com.pingidentity.admin.api.model.AlternativeLoginHintTokenIssuer;
import com.pingidentity.admin.api.model.AttributeMapping;
import com.pingidentity.admin.api.model.IdentityHintContract;
import com.pingidentity.admin.api.model.ResourceLink;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ApiModel(description="The set of attributes used to configure a CIBA request policy.")
public class RequestPolicy {
    private String id;
    private String name;
    private ResourceLink authenticatorRef;
    private ResourceLink userCodePcvRef;
    private int transactionLifetime;
    private boolean allowUnsignedLoginHintToken;
    private boolean requireTokenForIdentityHint;
    private List<AlternativeLoginHintTokenIssuer> alternativeLoginHintTokenIssuers = new ArrayList<AlternativeLoginHintTokenIssuer>();
    private IdentityHintContract identityHintContract;
    private AttributeMapping identityHintContractFulfillment;
    private AttributeMapping identityHintMapping;
    private Date lastModified;

    @ApiModelProperty(position=10, value="The request policy ID. ID is unique.", required=true)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @ApiModelProperty(position=20, value="The request policy name. Name is unique.", required=true)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(position=30, value="Reference to the associated authenticator.", required=true)
    public ResourceLink getAuthenticatorRef() {
        return this.authenticatorRef;
    }

    public void setAuthenticatorRef(ResourceLink authenticatorRef) {
        this.authenticatorRef = authenticatorRef;
    }

    @ApiModelProperty(position=40, value="Reference to the associated password credential validator.")
    public ResourceLink getUserCodePcvRef() {
        return this.userCodePcvRef;
    }

    public void setUserCodePcvRef(ResourceLink userCodePcvRef) {
        this.userCodePcvRef = userCodePcvRef;
    }

    @ApiModelProperty(position=50, value="The transaction lifetime in seconds.", required=true)
    public int getTransactionLifetime() {
        return this.transactionLifetime;
    }

    public void setTransactionLifetime(int transactionLifetime) {
        this.transactionLifetime = transactionLifetime;
    }

    @ApiModelProperty(position=60, value="Allow unsigned login hint token.")
    public boolean isAllowUnsignedLoginHintToken() {
        return this.allowUnsignedLoginHintToken;
    }

    public void setAllowUnsignedLoginHintToken(boolean allowUnsignedLoginHintToken) {
        this.allowUnsignedLoginHintToken = allowUnsignedLoginHintToken;
    }

    @ApiModelProperty(position=70, value="Require token for identity hint.")
    public boolean isRequireTokenForIdentityHint() {
        return this.requireTokenForIdentityHint;
    }

    public void setRequireTokenForIdentityHint(boolean requireTokenForIdentityHint) {
        this.requireTokenForIdentityHint = requireTokenForIdentityHint;
    }

    @ApiModelProperty(position=80, value="Alternative login hint token issuers.")
    public List<AlternativeLoginHintTokenIssuer> getAlternativeLoginHintTokenIssuers() {
        return this.alternativeLoginHintTokenIssuers;
    }

    public void setAlternativeLoginHintTokenIssuers(List<AlternativeLoginHintTokenIssuer> alternativeLoginHintTokenIssuers) {
        this.alternativeLoginHintTokenIssuers = alternativeLoginHintTokenIssuers;
    }

    @ApiModelProperty(position=90, value="Identity hint attribute contract.", required=true)
    public IdentityHintContract getIdentityHintContract() {
        return this.identityHintContract;
    }

    public void setIdentityHintContract(IdentityHintContract identityHintContract) {
        this.identityHintContract = identityHintContract;
    }

    @ApiModelProperty(position=100, value="Identity hint attribute contract fulfillment.")
    public AttributeMapping getIdentityHintContractFulfillment() {
        return this.identityHintContractFulfillment;
    }

    public void setIdentityHintContractFulfillment(AttributeMapping identityHintContractFulfillment) {
        this.identityHintContractFulfillment = identityHintContractFulfillment;
    }

    @ApiModelProperty(position=110, value="Identity hint contract to request policy mapping.", required=true)
    public AttributeMapping getIdentityHintMapping() {
        return this.identityHintMapping;
    }

    public void setIdentityHintMapping(AttributeMapping identityHintMapping) {
        this.identityHintMapping = identityHintMapping;
    }

    @ApiModelProperty(position=120, value="The time at which the request policy was last changed. This property is read only and is ignored on PUT and POST requests.")
    public Date getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return new Date(this.lastModified.getTime());
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified == null ? null : new Date(lastModified.getTime());
    }
}

