/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model;

import java.util.HashMap;
import java.util.Map;
import org.sourceid.wstrust.model.Saml11O365SecurityToken;
import org.sourceid.wstrust.model.Saml11SecurityToken;
import org.sourceid.wstrust.model.Saml20SecurityToken;

public enum SamlTokenType {
    SAML20(Saml20SecurityToken.TYPE),
    SAML11(Saml11SecurityToken.TYPE),
    SAML11_O365(Saml11O365SecurityToken.TYPE);

    private String id;
    private static final Map<String, SamlTokenType> DOMAIN_TO_API_TYPE_MAP;

    private SamlTokenType(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public static SamlTokenType getApiType(String domainType) {
        return DOMAIN_TO_API_TYPE_MAP.get(domainType);
    }

    static {
        DOMAIN_TO_API_TYPE_MAP = new HashMap<String, SamlTokenType>();
        for (SamlTokenType type : SamlTokenType.values()) {
            DOMAIN_TO_API_TYPE_MAP.put(type.getId(), type);
        }
    }
}

