/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.pingidentity.admin.api.model.BaseSigningSettings;
import com.pingidentity.admin.api.model.ResourceLink;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;

@JsonPropertyOrder(value={"signingKeyPairRef", "alternativeSigningKeyPairRefs", "algorithm", "includeCertInSignature", "includeRawKeyInSignature"})
@ApiModel(description="Settings related to signing messages sent to this partner.")
public class SigningSettings
extends BaseSigningSettings {
    private List<ResourceLink> alternativeSigningKeyPairRefs;

    @ApiModelProperty(position=20, value="The list of IDs of alternative key pairs used to sign messages sent to this partner. The ID of the key pair is also known as the alias and can be found by viewing the corresponding certificate under 'Signing & Decryption Keys & Certificates' in the PingFederate admin console.")
    public List<ResourceLink> getAlternativeSigningKeyPairRefs() {
        return this.alternativeSigningKeyPairRefs != null ? new ArrayList<ResourceLink>(this.alternativeSigningKeyPairRefs) : null;
    }

    public void addAlternativeSigningKeyPairRefs(ResourceLink alternativeSigningKeyPairRef) {
        if (this.alternativeSigningKeyPairRefs == null) {
            this.alternativeSigningKeyPairRefs = new ArrayList<ResourceLink>();
        }
        this.alternativeSigningKeyPairRefs.add(alternativeSigningKeyPairRef);
    }
}

