/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.pingidentity.admin.api.model.AssertionLifetime;
import com.pingidentity.admin.api.model.AuthenticationPolicyContractAssertionMapping;
import com.pingidentity.admin.api.model.BaseBrowserSso;
import com.pingidentity.admin.api.model.EncryptionPolicy;
import com.pingidentity.admin.api.model.IdpAdapterAssertionMapping;
import com.pingidentity.admin.api.model.Protocol;
import com.pingidentity.admin.api.model.SpBrowserSsoAttributeContract;
import com.pingidentity.admin.api.model.SpSamlIdentityMapping;
import com.pingidentity.admin.api.model.SpSsoServiceEndpoint;
import com.pingidentity.admin.api.model.SpWsFedIdentityMapping;
import com.pingidentity.admin.api.model.SsoServiceEndpoint;
import com.pingidentity.admin.api.model.WsFedTokenType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.sourceid.saml20.domain.WsTrustVersion;

@ApiModel(description="The SAML settings used to enable secure browser-based SSO to resources at your partner's site.")
public class SpBrowserSso
extends BaseBrowserSso {
    private List<SpSsoServiceEndpoint> ssoServiceEndpoints = null;
    private Boolean signAssertions = Boolean.FALSE;
    private Boolean signResponseAsRequired = null;
    private SpSamlIdentityMapping spSamlIdentityMapping;
    private SpWsFedIdentityMapping spWsFedIdentityMapping;
    private Boolean requireSignedAuthnRequests = Boolean.FALSE;
    private AssertionLifetime assertionLifetime;
    private EncryptionPolicy encryptionPolicy;
    private SpBrowserSsoAttributeContract attributeContract = new SpBrowserSsoAttributeContract();
    private List<IdpAdapterAssertionMapping> adapterMappings = new ArrayList<IdpAdapterAssertionMapping>();
    private List<AuthenticationPolicyContractAssertionMapping> authenticationPolicyContractAssertionMappings = new ArrayList<AuthenticationPolicyContractAssertionMapping>();
    private WsFedTokenType wsFedTokenType;
    private WsTrustVersion wsTrustVersion;

    @ApiModelProperty(position=15, value="The WS-Federation Token Type to use.")
    public WsFedTokenType getWsFedTokenType() {
        return this.wsFedTokenType;
    }

    public void setWsFedTokenType(WsFedTokenType wsFedTokenType) {
        this.wsFedTokenType = wsFedTokenType;
    }

    @ApiModelProperty(position=16, value="The WS-Trust version for a WS-Federation connection. The default version is WSTRUST12.")
    public WsTrustVersion getWsTrustVersion() {
        return this.wsTrustVersion;
    }

    public void setWsTrustVersion(WsTrustVersion wsTrustVersion) {
        this.wsTrustVersion = wsTrustVersion == null ? WsTrustVersion.WSTRUST12 : wsTrustVersion;
    }

    @ApiModelProperty(position=1010, value="Process in which users authenticated by the IdP are associated with user accounts local to the SP.")
    public SpSamlIdentityMapping getSpSamlIdentityMapping() {
        return this.spSamlIdentityMapping;
    }

    public void setSpSamlIdentityMapping(SpSamlIdentityMapping spSamlIdentityMapping) {
        this.spSamlIdentityMapping = spSamlIdentityMapping;
    }

    @ApiModelProperty(position=1011, value="Process in which users authenticated by the IdP are associated with user accounts local to the SP for WS-Federation connection types.")
    public SpWsFedIdentityMapping getSpWsFedIdentityMapping() {
        return this.spWsFedIdentityMapping;
    }

    public void setSpWsFedIdentityMapping(SpWsFedIdentityMapping spWsFedIdentityMapping) {
        this.spWsFedIdentityMapping = spWsFedIdentityMapping;
    }

    @ApiModelProperty(position=1015, value="Sign SAML Response as required by the associated binding and encryption policy. Applicable to SAML2.0 only and is defaulted to true. It can be set to false only on SAML2.0 connections when signAssertions is set to true.")
    public Boolean isSignResponseAsRequired() {
        if (this.getProtocol().equals((Object)Protocol.SAML20) && this.signResponseAsRequired == null) {
            return true;
        }
        return this.signResponseAsRequired;
    }

    public void setSignResponseAsRequired(Boolean signResponseAsRequired) {
        this.signResponseAsRequired = signResponseAsRequired;
    }

    @ApiModelProperty(position=1020, value="Always sign the SAML Assertion.")
    public Boolean isSignAssertions() {
        return this.signAssertions;
    }

    public void setSignAssertions(Boolean signAssertions) {
        this.signAssertions = signAssertions;
    }

    @ApiModelProperty(position=1030, value="Require AuthN requests to be signed when received via the POST or Redirect bindings.")
    public Boolean isRequireSignedAuthnRequests() {
        return this.requireSignedAuthnRequests;
    }

    public void setRequireSignedAuthnRequests(Boolean requireSignedAuthnRequests) {
        this.requireSignedAuthnRequests = requireSignedAuthnRequests;
    }

    @ApiModelProperty(position=1040, value="The SAML 2.0 encryption policy for browser-based SSO. Required for SAML 2.0 connections.")
    public EncryptionPolicy getEncryptionPolicy() {
        return this.encryptionPolicy;
    }

    public void setEncryptionPolicy(EncryptionPolicy encryptionPolicy) {
        this.encryptionPolicy = encryptionPolicy;
    }

    @ApiModelProperty(position=1060, value="A set of user attributes that the IdP sends in the SAML assertion.", required=true)
    public SpBrowserSsoAttributeContract getAttributeContract() {
        return this.attributeContract;
    }

    public void setAttributeContract(SpBrowserSsoAttributeContract attributeContract) {
        this.attributeContract = attributeContract == null ? new SpBrowserSsoAttributeContract() : attributeContract;
    }

    @ApiModelProperty(position=1070, value="A list of adapters that map to outgoing assertions.", required=true)
    public List<IdpAdapterAssertionMapping> getAdapterMappings() {
        return this.adapterMappings;
    }

    public void setAdapterMappings(List<IdpAdapterAssertionMapping> adapterMappings) {
        if (adapterMappings == null) {
            this.adapterMappings.clear();
        } else {
            this.adapterMappings = adapterMappings;
        }
    }

    @ApiModelProperty(position=1080, value="A list of authentication policy contracts that map to outgoing assertions.")
    public List<AuthenticationPolicyContractAssertionMapping> getAuthenticationPolicyContractAssertionMappings() {
        return this.authenticationPolicyContractAssertionMappings;
    }

    public void setAuthenticationPolicyContractAssertionMappings(List<AuthenticationPolicyContractAssertionMapping> authenticationPolicyContractAssertionMappings) {
        if (authenticationPolicyContractAssertionMappings == null) {
            this.authenticationPolicyContractAssertionMappings.clear();
        } else {
            this.authenticationPolicyContractAssertionMappings = authenticationPolicyContractAssertionMappings;
        }
    }

    @ApiModelProperty(position=1000, value="A list of possible endpoints to send assertions to.", required=true)
    public List<SpSsoServiceEndpoint> getSsoServiceEndpoints() {
        return this.ssoServiceEndpoints;
    }

    public void setSsoServiceEndpoints(List<SpSsoServiceEndpoint> ssoServiceEndpoints) {
        this.ssoServiceEndpoints = ssoServiceEndpoints;
    }

    @ApiModelProperty(position=1090, value="The timeframe of validity before and after the issuance of the assertion.", required=true)
    public AssertionLifetime getAssertionLifetime() {
        return this.assertionLifetime;
    }

    public void setAssertionLifetime(AssertionLifetime assertionLifetime) {
        this.assertionLifetime = assertionLifetime;
    }

    @Override
    @JsonIgnore
    public List<? extends SsoServiceEndpoint> getBaseSsoServiceEndpoints() {
        return this.ssoServiceEndpoints;
    }
}

