/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model;

import com.pingidentity.admin.api.model.ResourceLink;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.sourceid.saml20.service.TargetSessionId;

@ApiModel(description="SP URL mapping")
public class SpUrlMapping {
    private String url;
    private TargetUrlSource type;
    private ResourceLink ref;

    @ApiModelProperty(position=10, value="The URL that will be compared against the target URL. Use a wildcard (*) to match multiple URLs to the same adapter or connection instance.", required=true)
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @ApiModelProperty(position=20, value="The URL mapping type", required=true)
    public TargetUrlSource getType() {
        return this.type;
    }

    public void setType(TargetUrlSource type) {
        this.type = type;
    }

    @ApiModelProperty(position=30, value="The adapter or connection instance mapped for this URL.", required=true)
    public ResourceLink getRef() {
        return this.ref;
    }

    public void setRef(ResourceLink ref) {
        this.ref = ref;
    }

    public static enum TargetUrlSource {
        SP_ADAPTER(TargetSessionId.TargetSessionType.ADAPTER),
        SP_CONNECTION(TargetSessionId.TargetSessionType.SP_CONN);

        final TargetSessionId.TargetSessionType type;

        private TargetUrlSource(TargetSessionId.TargetSessionType type) {
            this.type = type;
        }

        public static TargetUrlSource fromType(TargetSessionId.TargetSessionType type) {
            switch (type) {
                case ADAPTER: {
                    return SP_ADAPTER;
                }
                case SP_CONN: {
                    return SP_CONNECTION;
                }
            }
            return null;
        }

        public TargetSessionId.TargetSessionType getDomainType() {
            return this.type;
        }
    }
}

