/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model;

import com.pingidentity.admin.api.model.IdpTokenProcessorMapping;
import com.pingidentity.admin.api.model.ProtocolMessageCustomization;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.SamlTokenType;
import com.pingidentity.admin.api.model.SpWsTrustAttributeContract;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;

@ApiModel(description="Ws-Trust STS provides security-token validation and creation to extend SSO access to identity-enabled Web Services")
public class SpWsTrust {
    private List<String> partnerServiceIds = new ArrayList<String>();
    private boolean oAuthAssertionProfiles;
    private SamlTokenType defaultTokenType = SamlTokenType.SAML20;
    private boolean generateKey;
    private boolean encryptSaml2Assertion;
    private int minutesBefore = 5;
    private int minutesAfter = 30;
    private SpWsTrustAttributeContract attributeContract = new SpWsTrustAttributeContract();
    private List<IdpTokenProcessorMapping> tokenProcessorMappings = new ArrayList<IdpTokenProcessorMapping>();
    private Boolean abortIfNotFulfilledFromRequest;
    private ResourceLink requestContractRef;
    private List<ProtocolMessageCustomization> messageCustomizations = null;

    @ApiModelProperty(position=10, value="The partner service identifiers.", required=true)
    public List<String> getPartnerServiceIds() {
        return this.partnerServiceIds;
    }

    public void setPartnerServiceIds(List<String> partnerServiceId) {
        this.partnerServiceIds = partnerServiceId;
    }

    @ApiModelProperty(name="oAuthAssertionProfiles", position=20, value="When selected, four additional token-type requests become available.")
    public boolean isoAuthAssertionProfiles() {
        return this.oAuthAssertionProfiles;
    }

    public void setoAuthAssertionProfiles(boolean oAuthAssertionProfiles) {
        this.oAuthAssertionProfiles = oAuthAssertionProfiles;
    }

    @ApiModelProperty(position=30, value="The default token type when a web service client (WSC) does not specify in the token request which token type the STS should issue. Defaults to SAML 2.0.")
    public SamlTokenType getDefaultTokenType() {
        return this.defaultTokenType;
    }

    public void setDefaultTokenType(SamlTokenType defaultTokenType) {
        this.defaultTokenType = defaultTokenType;
    }

    @ApiModelProperty(position=40, value="When selected, the STS generates a symmetric key to be used in conjunction with the \"Holder of Key\" (HoK) designation for the assertion's Subject Confirmation Method.  This option does not apply to OAuth assertion profiles.")
    public boolean isGenerateKey() {
        return this.generateKey;
    }

    public void setGenerateKey(boolean generateKey) {
        this.generateKey = generateKey;
    }

    @ApiModelProperty(position=50, value="When selected, the STS encrypts the SAML 2.0 assertion. Applicable only to SAML 2.0 security token.  This option does not apply to OAuth assertion profiles.")
    public boolean isEncryptSaml2Assertion() {
        return this.encryptSaml2Assertion;
    }

    public void setEncryptSaml2Assertion(boolean encryptSaml2Assertion) {
        this.encryptSaml2Assertion = encryptSaml2Assertion;
    }

    @ApiModelProperty(position=60, value="The amount of time before the SAML token was issued during which it is to be considered valid. The default value is 5.")
    public int getMinutesBefore() {
        return this.minutesBefore;
    }

    public void setMinutesBefore(int minutesBefore) {
        this.minutesBefore = minutesBefore;
    }

    @ApiModelProperty(position=70, value="The amount of time after the SAML token was issued during which it is to be considered valid. The default value is 30.")
    public int getMinutesAfter() {
        return this.minutesAfter;
    }

    public void setMinutesAfter(int minutesAfter) {
        this.minutesAfter = minutesAfter;
    }

    @ApiModelProperty(position=80, value="A set of user attributes that the IdP sends in the token.", required=true)
    public SpWsTrustAttributeContract getAttributeContract() {
        return this.attributeContract;
    }

    public void setAttributeContract(SpWsTrustAttributeContract attributeContract) {
        this.attributeContract = attributeContract == null ? new SpWsTrustAttributeContract() : attributeContract;
    }

    @ApiModelProperty(position=90, value="A list of token processors to validate incoming tokens.", required=true)
    public List<IdpTokenProcessorMapping> getTokenProcessorMappings() {
        return this.tokenProcessorMappings;
    }

    public void setTokenProcessorMappings(List<IdpTokenProcessorMapping> tokenProcessorMappings) {
        this.tokenProcessorMappings = tokenProcessorMappings;
    }

    @ApiModelProperty(position=100, value="If the attribute contract cannot be fulfilled using data from the Request, abort the transaction.")
    public Boolean isAbortIfNotFulfilledFromRequest() {
        return this.abortIfNotFulfilledFromRequest;
    }

    public void setAbortIfNotFulfilledFromRequest(Boolean abortIfNotFulfilledFromRequest) {
        this.abortIfNotFulfilledFromRequest = abortIfNotFulfilledFromRequest;
    }

    @ApiModelProperty(position=110, value="Request Contract to be used to map attribute values into the security token.")
    public ResourceLink getRequestContractRef() {
        return this.requestContractRef;
    }

    public void setRequestContractRef(ResourceLink requestContractRef) {
        this.requestContractRef = requestContractRef;
    }

    @ApiModelProperty(position=120, value="The message customizations for WS-Trust. Depending on server settings, connection type, and protocol this may or may not be supported.")
    public List<ProtocolMessageCustomization> getMessageCustomizations() {
        return this.messageCustomizations;
    }

    public void setMessageCustomizations(List<ProtocolMessageCustomization> messageCustomizations) {
        this.messageCustomizations = messageCustomizations;
    }
}

