/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model;

import java.util.HashMap;
import java.util.Map;
import org.sourceid.wstrust.model.WsTrustTokenType;

public enum WsFedTokenType {
    SAML11(WsTrustTokenType.SAML11),
    SAML20(WsTrustTokenType.SAML20),
    JWT(WsTrustTokenType.JWT);

    private WsTrustTokenType value;
    private static Map<String, WsFedTokenType> uri2Type;

    private WsFedTokenType(WsTrustTokenType value) {
        this.value = value;
    }

    public WsTrustTokenType getValue() {
        return this.value;
    }

    public static WsFedTokenType fromUri(String uri) {
        return uri2Type.get(uri);
    }

    static {
        uri2Type = new HashMap<String, WsFedTokenType>();
        uri2Type.put(WsTrustTokenType.SAML11.getUri(), SAML11);
        uri2Type.put(WsTrustTokenType.SAML20.getUri(), SAML20);
        uri2Type.put(WsTrustTokenType.JWT.getUri(), JWT);
    }
}

