/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model;

import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.UsernamePasswordCredentials;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;

@ApiModel(description="Configure PingFederate to require that client applications provide credentials to access the WS-Trust STS endpoints.")
public class WsTrustStsSettings {
    boolean basicAuthnEnabled;
    boolean clientCertAuthnEnabled;
    boolean restrictBySubjectDn;
    boolean restrictByIssuerCert;
    List<String> subjectDns = new ArrayList<String>();
    List<UsernamePasswordCredentials> users = new ArrayList<UsernamePasswordCredentials>();
    List<ResourceLink> issuerCerts = new ArrayList<ResourceLink>();

    @ApiModelProperty(position=10, value="Require the use of HTTP Basic Authentication to access WS-Trust STS endpoints. Requires users be populated.")
    public boolean isBasicAuthnEnabled() {
        return this.basicAuthnEnabled;
    }

    public void setBasicAuthnEnabled(boolean basicAuthnEnabled) {
        this.basicAuthnEnabled = basicAuthnEnabled;
    }

    @ApiModelProperty(position=20, value="Require the use of Client Cert Authentication to access WS-Trust STS endpoints. Requires either restrictBySubjectDn and/or restrictByIssuerCert be enabled.")
    public boolean isClientCertAuthnEnabled() {
        return this.clientCertAuthnEnabled;
    }

    public void setClientCertAuthnEnabled(boolean clientCertAuthnEnabled) {
        this.clientCertAuthnEnabled = clientCertAuthnEnabled;
    }

    @ApiModelProperty(position=30, value="Restrict Access by Subject DN. Ignored if clientCertAuthnEnabled is disabled.")
    public boolean isRestrictBySubjectDn() {
        return this.restrictBySubjectDn;
    }

    public void setRestrictBySubjectDn(boolean restrictBySubjectDn) {
        this.restrictBySubjectDn = restrictBySubjectDn;
    }

    @ApiModelProperty(position=40, value="Restrict Access by Issuer Certificate. Ignored if clientCertAuthnEnabled is disabled.")
    public boolean isRestrictByIssuerCert() {
        return this.restrictByIssuerCert;
    }

    public void setRestrictByIssuerCert(boolean restrictByIssuerCert) {
        this.restrictByIssuerCert = restrictByIssuerCert;
    }

    @ApiModelProperty(position=50, value="List of Subject DNs for certificates that are allowed to authenticate to WS-Trust STS endpoints. Required if restrictBySubjectDn is enabled.")
    public List<String> getSubjectDns() {
        return this.subjectDns;
    }

    public void setSubjectDns(List<String> subjectDns) {
        this.subjectDns = subjectDns;
    }

    @ApiModelProperty(position=60, value="List of users authorized to access WS-Trust STS endpoints when basicAuthnEnabled is enabled. At least one users entry is required if basicAuthnEnabled is enabled.")
    public List<UsernamePasswordCredentials> getUsers() {
        return this.users;
    }

    public void setUsers(List<UsernamePasswordCredentials> users) {
        this.users = users;
    }

    @ApiModelProperty(position=70, value="List of certificate Issuers that are used to validate certificates for access to the WS-Trust STS endpoints. Required if restrictByIssuerCert is enabled.")
    public List<ResourceLink> getIssuerCerts() {
        return this.issuerCerts;
    }

    public void setIssuerCerts(List<ResourceLink> issuerCerts) {
        this.issuerCerts = issuerCerts;
    }
}

