/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model.auditing;

import com.pingidentity.admin.api.model.ResourceLink;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import org.sourceid.saml20.domain.AuditLoggingSettings;

@ApiModel(description="Settings for audit logging.")
public class AuditLoggingSettings {
    private AuditLoggingSettings.AuditLoggingFailureMode failureMode;
    private ResourceLink notificationPublisher;
    private Integer threshold;
    private Integer interval;
    private boolean trackAuditLogFailures;
    private List<String> emailsToNotify;

    @ApiModelProperty(position=5, value="Determines what should happen to transactions when the failure threshold is hit. Default is BLOCK.")
    public AuditLoggingSettings.AuditLoggingFailureMode getFailureMode() {
        return this.failureMode;
    }

    public void setFailureMode(AuditLoggingSettings.AuditLoggingFailureMode failureMode) {
        this.failureMode = failureMode;
    }

    @ApiModelProperty(position=10, value="Determines whether PingFederate should track audit log failures to enable notifications in case of failure. Default is false.")
    public boolean isTrackAuditLogFailures() {
        return this.trackAuditLogFailures;
    }

    public void setTrackAuditLogFailures(boolean trackAuditLogFailures) {
        this.trackAuditLogFailures = trackAuditLogFailures;
    }

    @ApiModelProperty(position=20, value="Reference to the associated notification publisher to use for audit log notifications.")
    public ResourceLink getNotificationPublisher() {
        return this.notificationPublisher;
    }

    public void setNotificationPublisher(ResourceLink notificationPublisher) {
        this.notificationPublisher = notificationPublisher;
    }

    @ApiModelProperty(position=21, value="A list of emails that will be notified when the audit logging failure threshold is hit. Requires the Notification Publisher to support SMTP.")
    public List<String> getEmailsToNotify() {
        return this.emailsToNotify;
    }

    public void setEmailsToNotify(List<String> emailsToNotify) {
        this.emailsToNotify = emailsToNotify;
    }

    @ApiModelProperty(position=30, value="Specifies the percent of failed auditing attempts during the configured interval where the system will consider auditing to be in a failure state. The default is 80%.")
    public Integer getThreshold() {
        return this.threshold;
    }

    public void setThreshold(Integer threshold) {
        this.threshold = threshold;
    }

    @ApiModelProperty(position=40, value="Specifies the interval in seconds over which the failure rate is calculated. The default is 300 seconds.")
    public Integer getInterval() {
        return this.interval;
    }

    public void setInterval(Integer interval) {
        this.interval = interval;
    }
}

