/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model.bulkconfig;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.pingidentity.admin.api.model.bulkconfig.ConfigOperationDeserializer;
import com.pingidentity.admin.api.model.bulkconfig.ConfigOperationSerializer;
import com.pingidentity.admin.api.model.bulkconfig.ConfigOperationType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;

@ApiModel(description="Model describing a list of configuration operations for a given resource type.")
@JsonSerialize(using=ConfigOperationSerializer.class)
@JsonDeserialize(using=ConfigOperationDeserializer.class)
public class ConfigOperation {
    private String resourceType;
    private ConfigOperationType operationType;
    private List<Object> items;
    private List<String> itemIds;
    private String subResource;

    @ApiModelProperty(position=10, value="The identifier for the resource type the operation applies to.", required=true)
    public String getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    @ApiModelProperty(position=15, value="The subresource for the operation.", notes="Currently, the only resource type that supports subresources is /configStore.")
    public String getSubResource() {
        return this.subResource;
    }

    public void setSubResource(String subResource) {
        this.subResource = subResource;
    }

    @ApiModelProperty(position=20, value="The type of operation to be performed.", required=true, notes="Currently, the DELETE operation is only supported for the /configStore resource type.")
    public ConfigOperationType getOperationType() {
        return this.operationType;
    }

    public void setOperationType(ConfigOperationType operationType) {
        this.operationType = operationType;
    }

    @ApiModelProperty(position=30, value="The configuration items for the operation. This field only applies to the SAVE operation type.")
    public List<Object> getItems() {
        return this.items;
    }

    public void setItems(List<Object> items) {
        this.items = items;
    }

    @ApiModelProperty(position=40, value="The item ID's for the operation. This field only applies to the DELETE operation type.")
    public List<String> getItemIds() {
        return this.itemIds;
    }

    public void setItemIds(List<String> itemIds) {
        this.itemIds = itemIds;
    }
}

