/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model.collectsupportdata;

import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.collectsupportdata.CsdArchiveStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;

@ApiModel(description="Information about a CSD archive.")
public class CsdArchiveInfo {
    private String nodeIndex;
    private String archiveId;
    private String address;
    private Date timestamp;
    private CsdArchiveStatus status;
    private ResourceLink statusLink;
    private ResourceLink exportLink;

    @ApiModelProperty(position=10, value="The node index of the PingFederate node that the archive is being collected from.")
    public String getNodeIndex() {
        return this.nodeIndex;
    }

    public void setNodeIndex(String nodeIndex) {
        this.nodeIndex = nodeIndex;
    }

    @ApiModelProperty(position=20, value="The ID of the CSD archive.")
    public String getArchiveId() {
        return this.archiveId;
    }

    public void setArchiveId(String archiveId) {
        this.archiveId = archiveId;
    }

    @ApiModelProperty(position=30, value="The address of the PingFederate node that the archive is being collected from.")
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    @ApiModelProperty(position=40, value="The timestamp of when the collection of the archive started.")
    public Date getTimestamp() {
        if (this.timestamp == null) {
            return null;
        }
        return new Date(this.timestamp.getTime());
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp == null ? null : new Date(timestamp.getTime());
    }

    @ApiModelProperty(position=50, value="The status of the archive.")
    public CsdArchiveStatus getStatus() {
        return this.status;
    }

    public void setStatus(CsdArchiveStatus status) {
        this.status = status;
    }

    @ApiModelProperty(position=60, value="A reference to the status endpoint of the archive.")
    public ResourceLink getStatusLink() {
        return this.statusLink;
    }

    public void setStatusLink(ResourceLink statusLink) {
        this.statusLink = statusLink;
    }

    @ApiModelProperty(position=70, value="A reference to the export endpoint of the archive.")
    public ResourceLink getExportLink() {
        return this.exportLink;
    }

    public void setExportLink(ResourceLink exportLink) {
        this.exportLink = exportLink;
    }
}

