/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model.connmetadata;

import com.pingidentity.admin.api.model.Connection;
import com.pingidentity.admin.api.model.ConnectionType;
import com.pingidentity.admin.api.model.connmetadata.MetadataProtocol;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description="A request for converting SAML connection metadata into a JSON connection.")
public class ConvertMetadataRequest {
    private ConnectionType connectionType;
    private MetadataProtocol expectedProtocol;
    private String samlMetadata;
    private String verificationCertificate;
    private Connection templateConnection;
    private String expectedEntityId;

    @ApiModelProperty(position=10, value="The expected connection type to convert.", required=true)
    public ConnectionType getConnectionType() {
        return this.connectionType;
    }

    public void setConnectionType(ConnectionType connectionType) {
        this.connectionType = connectionType;
    }

    @ApiModelProperty(position=20, value="The expected browser-based SSO protocol to convert. In this case the protocol is restricted to SAML.", required=true)
    public MetadataProtocol getExpectedProtocol() {
        return this.expectedProtocol;
    }

    public void setExpectedProtocol(MetadataProtocol expectedProtocol) {
        this.expectedProtocol = expectedProtocol;
    }

    @ApiModelProperty(position=25, value="The entity ID of the connection to be obtained from the input SAML Metadata. Required if the SAML Metadata has more than one connection defined.")
    public String getExpectedEntityId() {
        return this.expectedEntityId;
    }

    public void setExpectedEntityId(String entityId) {
        this.expectedEntityId = entityId;
    }

    @ApiModelProperty(position=30, value="The base-64 encoded XML SAML metadata.", required=true)
    public String getSamlMetadata() {
        return this.samlMetadata;
    }

    public void setSamlMetadata(String samlMetadata) {
        this.samlMetadata = samlMetadata;
    }

    @ApiModelProperty(position=40, value="The certificate to validate the metadata signature against. The certificate can be in PEM format or base-64 encoded DER format.")
    public String getVerificationCertificate() {
        return this.verificationCertificate;
    }

    public void setVerificationCertificate(String verificationCertificate) {
        this.verificationCertificate = verificationCertificate;
    }

    @ApiModelProperty(position=50, value="The template connection to overlay the metadata on.")
    public Connection getTemplateConnection() {
        return this.templateConnection;
    }

    public void setTemplateConnection(Connection templateConnection) {
        this.templateConnection = templateConnection;
    }
}

