/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model.fieldpaths;

import com.pingidentity.admin.api.model.Protocol;
import com.pingidentity.admin.api.model.fieldpaths.oauth.AccessTokenMappingPaths;
import org.sourceid.saml20.metadata.Role;

public class ConnectionPaths {
    public static String getConnectionId() {
        return "id";
    }

    public static String getConnectionEntityId() {
        return "entityId";
    }

    public static String getConnectionName() {
        return "name";
    }

    public static String getSpSamlIdentityMapping() {
        return "spSamlIdentityMapping";
    }

    public static String getSpWsFedIdentityMapping() {
        return "spWsFedIdentityMapping";
    }

    public static String getWsTrustTokenType() {
        return "wsTrustTokenType";
    }

    public static String getDefaultVirtualEntityId() {
        return "defaultVirtualEntityId";
    }

    public static String getVirtualEntityIds() {
        return "virtualEntityIds";
    }

    public static String getVirtualEntityPath(String basePath, int index) {
        return basePath + ".virtualEntityIds[" + index + "]";
    }

    public static String getVirtualEntityId(int index) {
        return ConnectionPaths.getVirtualEntityIds() + "[" + index + "]";
    }

    public static String getMetadataReload() {
        return "metadataReload";
    }

    public static String getMetadataReloadUrlResource() {
        return ConnectionPaths.getMetadataReload() + ".metadataUrl";
    }

    public static String getMetadataReloadUrlResourceId() {
        return ConnectionPaths.getMetadataReloadUrlResource() + ".id";
    }

    public static String getBaseUrl() {
        return "baseUrl";
    }

    public static String getApplicationIconUrl() {
        return "applicationIconUrl";
    }

    public static String getContactEmail() {
        return "contactInfo.email";
    }

    public static String getLicenseConnectionGroup() {
        return "licenseConnectionGroup";
    }

    public static String getBrowserSsoPropertyName(Role role) {
        if (role == Role.IDP) {
            return "idpBrowserSso";
        }
        return "spBrowserSso";
    }

    public static String getUrlWhiteListEntries(Role role, int index) {
        return ConnectionPaths.getBrowserSsoPropertyName(role) + ".urlWhitelistEntries[" + index + "]";
    }

    public static String getBrowserSsoProtocolPath(Role role) {
        return ConnectionPaths.getBrowserSsoPropertyName(role) + ".protocol";
    }

    public static String getEncryptionPolicyPath(Role role) {
        return ConnectionPaths.getBrowserSsoPropertyName(role) + ".encryptionPolicy";
    }

    public static String getSpBrowserSsoSignResponseAsRequired() {
        return ConnectionPaths.getBrowserSsoPropertyName(Role.SP) + ".signResponseAsRequired";
    }

    public static String getSpBrowserSsoWantAssertionsSigned() {
        return ConnectionPaths.getBrowserSsoPropertyName(Role.SP) + ".wantAssertionsSigned";
    }

    public static String getEncryptedAttributesPath(Role role) {
        return ConnectionPaths.getEncryptionPolicyPath(role) + ".encryptedAttributes";
    }

    public static String getEncryptionPolicyEncryptSubjectPath(Role role) {
        return ConnectionPaths.getEncryptionPolicyPath(role) + ".encryptSloSubjectNameId";
    }

    public static String getEncryptionPolicyAcceptEncryptedSubjectPath(Role role) {
        return ConnectionPaths.getEncryptionPolicyPath(role) + ".sloSubjectNameIDEncrypted";
    }

    public static String getEnabledProfilesPropertyPath(Role role) {
        return ConnectionPaths.getBrowserSsoPropertyName(role) + ".enabledProfiles";
    }

    public static String getSsoServiceEndpointsPropertyPath(Role role) {
        return ConnectionPaths.getBrowserSsoPropertyName(role) + ".ssoServiceEndpoints";
    }

    public static String getSsoServiceEndpointsPropertyPath(Role role, int index) {
        return ConnectionPaths.getBrowserSsoPropertyName(role) + ".ssoServiceEndpoints[" + index + "]";
    }

    public static String getSloServiceEndpointsPropertyPath(Role role) {
        return ConnectionPaths.getBrowserSsoPropertyName(role) + ".sloServiceEndpoints";
    }

    public static String getSloServiceEndpointsPropertyPath(Role role, int index) {
        return ConnectionPaths.getBrowserSsoPropertyName(role) + ".sloServiceEndpoints[" + index + "]";
    }

    public static String getMessageCustomizationsPropertyPath(Role role, Protocol protocol) {
        if (protocol == null) {
            return ConnectionPaths.getWsTrust() + ".messageCustomizations";
        }
        return ConnectionPaths.getBrowserSsoPropertyName(role) + ".messageCustomizations";
    }

    public static String getMessageCustomizationNamePropertyPath(Role role, int index, Protocol protocol) {
        return ConnectionPaths.getMessageCustomizationsPropertyPath(role, protocol) + "[" + index + "].contextName";
    }

    public static String getMessageCustomizationExprPropertyPath(Role role, int index, Protocol protocol) {
        return ConnectionPaths.getMessageCustomizationsPropertyPath(role, protocol) + "[" + index + "].messageExpression";
    }

    public static String getAssertionLifetimePropertyPath() {
        return ConnectionPaths.getBrowserSsoPropertyName(Role.SP) + ".assertionLifetime";
    }

    public static String getAssertionBeforeLifetimePropertyPath() {
        return ConnectionPaths.getAssertionLifetimePropertyPath() + ".minutesBefore";
    }

    public static String getAssertionAfterLifetimePropertyPath() {
        return ConnectionPaths.getAssertionLifetimePropertyPath() + ".minutesAfter";
    }

    public static String getArtifactLifetimePropertyPath(Role role) {
        return ConnectionPaths.getArtifactPropertyPath(role) + ".artifactLifetime";
    }

    public static String getArtifactResolverLocationsPropertyPath(Role role) {
        return ConnectionPaths.getArtifactPropertyPath(role) + ".resolverLocations";
    }

    public static String getArtifactSourceIdPropertyPath(Role role) {
        return ConnectionPaths.getArtifactPropertyPath(role) + ".sourceId";
    }

    public static String getArtifactResolverLocationsIndexPath(Role role, int index) {
        return ConnectionPaths.getSsoServiceEndpointsPropertyPath(role) + "[" + index + "].index";
    }

    public static String getArtifactResolverLocationsUrlPath(Role role, int index) {
        return ConnectionPaths.getArtifactResolverLocationsPropertyPath(role) + "[" + index + "].url";
    }

    public static String getSpSsoServiceEndpointsIndexPath(int index) {
        return ConnectionPaths.getSsoServiceEndpointsPropertyPath(Role.SP) + "[" + index + "].index";
    }

    public static String getSsoServiceEndpointsUrlPath(Role role, int index) {
        return ConnectionPaths.getSsoServiceEndpointsPropertyPath(role) + "[" + index + "].url";
    }

    public static String getSloServiceEndpointsUrlPath(Role role, int index) {
        return ConnectionPaths.getSloServiceEndpointsPropertyPath(role) + "[" + index + "].url";
    }

    public static String getSloServiceEndpointsResponseUrlPath(Role role, int index) {
        return ConnectionPaths.getSloServiceEndpointsPropertyPath(role) + "[" + index + "].responseUrl";
    }

    public static String getSsoServiceEndpointsBindingPath(Role role, int index) {
        return ConnectionPaths.getSsoServiceEndpointsPropertyPath(role) + "[" + index + "].binding";
    }

    public static String getIncomingBindingsPropertyPath(Role role) {
        return ConnectionPaths.getBrowserSsoPropertyName(role) + ".incomingBindings";
    }

    public static String getDefaultTargetUrlPath(Role role) {
        return ConnectionPaths.getBrowserSsoPropertyName(role) + ".defaultTargetUrl";
    }

    public static String getIdpIdentityMappingPath() {
        return ConnectionPaths.getBrowserSsoPropertyName(Role.IDP) + ".idpIdentityMapping";
    }

    public static String getSpSamlIdentityMappingPath() {
        return ConnectionPaths.getBrowserSsoPropertyName(Role.SP) + ".spSamlIdentityMapping";
    }

    public static String getBrowserSsoAttrContractPath(Role role) {
        return ConnectionPaths.getBrowserSsoPropertyName(role) + ".attributeContract";
    }

    public static String getOAuthAttrContractPath(Role role) {
        return "oAuthAttributeContract.attributeContract";
    }

    public static String getCoreAttributes(String attributeContractPath) {
        return attributeContractPath + ".coreAttributes";
    }

    public static String getExtendedAttributesPath(String attributeContractPath) {
        return attributeContractPath + ".extendedAttributes";
    }

    public static String getResourceIdIdPath(String basePath) {
        return basePath + ".id";
    }

    public static String getAttributeSourceIdPath(String basePath) {
        return basePath + ".id";
    }

    public static String getAttributeSourceDescriptionPath(String basePath) {
        return basePath + ".description";
    }

    public static String getSpAdapterMappingsPath() {
        return ConnectionPaths.getBrowserSsoPropertyName(Role.IDP) + ".adapterMappings";
    }

    public static String getAuthenticationPolicyContractMappingsPath() {
        return ConnectionPaths.getBrowserSsoPropertyName(Role.IDP) + ".authenticationPolicyContractMappings";
    }

    public static String getTargetSessionMappingsPath() {
        return ConnectionPaths.getBrowserSsoPropertyName(Role.IDP) + ".targetSessionMappings";
    }

    public static String getAuthenticationSourceMappingsPath() {
        return ConnectionPaths.getBrowserSsoPropertyName(Role.SP) + ".authenticationSourceMappings";
    }

    public static String getIdpAdapterMappingsPath() {
        return ConnectionPaths.getBrowserSsoPropertyName(Role.SP) + ".adapterMappings";
    }

    public static String getAuthenticationPolicyContractAssertionMappingsPath() {
        return ConnectionPaths.getBrowserSsoPropertyName(Role.SP) + ".authenticationPolicyContractAssertionMappings";
    }

    public static String getSpAdapterMappingsPath(int index) {
        return ConnectionPaths.getBrowserSsoPropertyName(Role.IDP) + ".adapterMappings[" + index + "]";
    }

    public static String getAuthenticationPolicyContractMappingsPath(int index) {
        return ConnectionPaths.getBrowserSsoPropertyName(Role.IDP) + ".authenticationPolicyContractMappings[" + index + "]";
    }

    public static String getIdpAdapterMappingsPath(int index) {
        return ConnectionPaths.getBrowserSsoPropertyName(Role.SP) + ".adapterMappings[" + index + "]";
    }

    public static String getAuthenticationPolicyContractAssertionMappingsPath(int index) {
        return ConnectionPaths.getBrowserSsoPropertyName(Role.SP) + ".authenticationPolicyContractAssertionMappings[" + index + "]";
    }

    public static String getSpAdapterMappingAdapterLinkPath(int index) {
        return ConnectionPaths.getSpAdapterMappingsPath(index) + ".spAdapterRef";
    }

    public static String getIdpAccessTokenManagerBasePath(int index) {
        return ConnectionPaths.getIdpOAuthGrantAttributeMapping() + ".accessTokenManagerMappings[" + index + "]";
    }

    public static String getIdpAccessTokenManagerLinkPath(int index) {
        return ConnectionPaths.getIdpAccessTokenManagerBasePath(index) + "." + AccessTokenMappingPaths.getAccessTokenManagerBase();
    }

    public static String getAuthenticationPolicyContractMappingApcLinkPath(int index) {
        return ConnectionPaths.getAuthenticationPolicyContractMappingsPath(index) + ".authenticationPolicyContractRef";
    }

    public static String getAuthenticationPolicyContractAssertionMappingApcLinkPath(int index) {
        return ConnectionPaths.getAuthenticationPolicyContractAssertionMappingsPath(index) + ".authenticationPolicyContractRef";
    }

    public static String getIdpAdapterMappingAdapterLinkPath(int index) {
        return ConnectionPaths.getIdpAdapterMappingsPath(index) + ".idpAdapterRef";
    }

    public static String getIdpAdapterMappingAbortSsoPath(int index) {
        return ConnectionPaths.getIdpAdapterMappingsPath(index) + ".abortSsoTransactionAsFailSafe";
    }

    public static String getIdpAdapterMappingContractFulfillmentPath(int index) {
        return ConnectionPaths.getAttributeMappingContractFulfillmentPath(ConnectionPaths.getIdpAdapterMappingsPath(index));
    }

    public static String getAuthenticationPolicyContractAssertionMappingAbortSsoPath(int index) {
        return ConnectionPaths.getAuthenticationPolicyContractAssertionMappingsPath(index) + ".abortSsoTransactionAsFailSafe";
    }

    public static String getAuthenticationPolicyContractContractFulfillmentPath(int index) {
        return ConnectionPaths.getAttributeMappingContractFulfillmentPath(ConnectionPaths.getAuthenticationPolicyContractAssertionMappingsPath(index));
    }

    public static String getSpAdapterMappingAdapterLinkIdPath(int index) {
        return ConnectionPaths.getSpAdapterMappingAdapterLinkPath(index) + ".id";
    }

    public static String getIdpAdapterMappingAdapterLinkIdPath(int index) {
        return ConnectionPaths.getIdpAdapterMappingAdapterLinkPath(index) + ".id";
    }

    public static String getSpAdapterMappingAttributeSourcePath(int index) {
        return ConnectionPaths.getSpAdapterMappingsPath(index) + ".attributeSources";
    }

    public static String getAuthenticationPolicyContractMappingAttributeSourcePath(int index) {
        return ConnectionPaths.getAuthenticationPolicyContractMappingsPath(index) + ".attributeSources";
    }

    public static String getIdpAdapterMappingAttributeSourcePath(int index) {
        return ConnectionPaths.getIdpAdapterMappingsPath(index) + ".attributeSources";
    }

    public static String getIdpAdapterMappingAttributeAdapterOverrideSettings(int index) {
        return ConnectionPaths.getIdpAdapterMappingsPath(index) + ".adapterOverrideSettings";
    }

    public static String getIdpAdapterOverrideSettingsParentRefPath(int index) {
        return ConnectionPaths.getIdpAdapterMappingAttributeAdapterOverrideSettings(index) + ".parentRef";
    }

    public static String getSpAdapterMappingAttributeAdapterOverrideSettings(int index) {
        return ConnectionPaths.getSpAdapterMappingsPath(index) + ".adapterOverrideSettings";
    }

    public static String getSpAdapterOverrideSettingsParentRefPath(int index) {
        return ConnectionPaths.getSpAdapterMappingAttributeAdapterOverrideSettings(index) + ".parentRef";
    }

    public static String getSpAdapterMappingRestrictedVirtualEntityIdPath(int mappingIndex) {
        return ConnectionPaths.getSpAdapterMappingsPath(mappingIndex) + ".restrictedVirtualEntityIds";
    }

    public static String getAuthenticationPolicyContractMappingRestrictedVirtualServerIdPath(int mappingIndex) {
        return ConnectionPaths.getAuthenticationPolicyContractMappingsPath(mappingIndex) + ".restrictedVirtualServerIds";
    }

    public static String getSpAdapterMappingRestrictedVirtualEntityIdPath(int mappingIndex, int vsidIndex) {
        return ConnectionPaths.getSpAdapterMappingsPath(mappingIndex) + ".restrictedVirtualEntityIds[" + vsidIndex + "]";
    }

    public static String getAuthenticationPolicyContractMappingRestrictedVirtualServerIdPath(int mappingIndex, int vsidIndex) {
        return ConnectionPaths.getAuthenticationPolicyContractMappingsPath(mappingIndex) + ".restrictedVirtualServerIds[" + vsidIndex + "]";
    }

    public static String getIdpAdapterMappingRestrictedVirtualEntityIdPath(int mappingIndex, int vsidIndex) {
        return ConnectionPaths.getIdpAdapterMappingsPath(mappingIndex) + ".restrictedVirtualEntityIds[" + vsidIndex + "]";
    }

    public static String getAuthenticationPolicyContractAssertionMappingRestrictedVirtualEntityIdPath(int mappingIndex, int vsidIndex) {
        return ConnectionPaths.getAuthenticationPolicyContractAssertionMappingsPath(mappingIndex) + ".restrictedVirtualEntityIds[" + vsidIndex + "]";
    }

    public static String getIdpAdapterMappingRestrictedVirtualEntityIdPath(int mappingIndex) {
        return ConnectionPaths.getIdpAdapterMappingsPath(mappingIndex) + ".restrictedVirtualEntityIds";
    }

    public static String getAuthenticationPolicyContractAssertionMappingRestrictedVirtualEntityIdPath(int mappingIndex) {
        return ConnectionPaths.getAuthenticationPolicyContractAssertionMappingsPath(mappingIndex) + ".restrictedVirtualEntityIds";
    }

    public static String getAttributeSourcesPath(String basePath) {
        return ConnectionPaths.checkEmptyBasePathAndStripLeadingPeriod(basePath, ".attributeSources");
    }

    public static String getAttributeSourcePath(String basePath, int sourcesIndex) {
        return ConnectionPaths.getAttributeSourcesPath(basePath) + "[" + sourcesIndex + "]";
    }

    public static String getAttributeSourceDataStoreLinkPath(String basePath) {
        return basePath + ".dataStoreRef";
    }

    public static String getAttributeSourceDataStoreLinkIdPath(String basePath) {
        return ConnectionPaths.getAttributeSourceDataStoreLinkPath(basePath) + ".id";
    }

    public static String getAttributeSourceDataStoreTypePath(String basePath) {
        return basePath + ".type";
    }

    public static String getAttributeSourceCustomDSFilterPath(String basePath) {
        return basePath + ".filterFields";
    }

    public static String getAttributeSourceLdapDSBaseDnPath(String basePath) {
        return basePath + ".baseDn";
    }

    public static String getAttributeSourceLdapDSSearchScopePath(String basePath) {
        return basePath + ".searchScope";
    }

    public static String getAttributeSourceLdapDSSearchFilterPath(String basePath) {
        return basePath + ".searchFilter";
    }

    public static String getAttributeSourceLdapDSSearchAttributesPath(String basePath) {
        return basePath + ".searchAttributes";
    }

    public static String getAttributeSourceLdapDSMemberOfNestedGroup(String basePath) {
        return basePath + ".memberOfNestedGroup";
    }

    public static String getAttributeSourceJdbcDSTablePath(String basePath) {
        return basePath + ".table";
    }

    public static String getAttributeSourceJdbcDSStoredProcedurePath(String basePath) {
        return basePath + ".storedProcedure";
    }

    public static String getAttributeSourceJdbcDSFilterPath(String basePath) {
        return basePath + ".filter";
    }

    public static String getAttributeSourceJdbcDSColumnNamesPath(String basePath) {
        return basePath + ".columnNames";
    }

    public static String getAttributeMappingContractFulfillmentPath(String basePath) {
        return ConnectionPaths.checkEmptyBasePathAndStripLeadingPeriod(basePath, ".attributeContractFulfillment");
    }

    public static String getAttributeMappingPath(String baseMappingPath, String attrName) {
        return baseMappingPath + "[\"" + ConnectionPaths.encodeAttributeName(attrName) + "\"]";
    }

    private static String encodeAttributeName(String attributeName) {
        String encodedName = attributeName.replaceAll("\\\\", "\\\\\\\\");
        encodedName = encodedName.replaceAll("\"", "\\\\\"");
        return encodedName;
    }

    public static String getSourcePath(String basePath) {
        return basePath + ".source";
    }

    public static String getSourceTypePath(String basePath) {
        return ConnectionPaths.getSourcePath(basePath) + ".type";
    }

    public static String getAttributeMappingValuePath(String baseMappingPath, String attrName) {
        return ConnectionPaths.getAttributeMappingPath(baseMappingPath, attrName) + ".value";
    }

    public static String getIssuanceCriteriaPath(String basePath) {
        return ConnectionPaths.checkEmptyBasePathAndStripLeadingPeriod(basePath, ".issuanceCriteria");
    }

    public static String getConditionalIssuanceCriteriaPath(String basePath, int index) {
        return ConnectionPaths.getIssuanceCriteriaPath(basePath) + ".conditionalCriteria[" + index + "]";
    }

    public static String getConditionalIssuanceCriteriaAttrNamePath(String basePath) {
        return basePath + ".attributeName";
    }

    public static String getConditionalIssuanceCriteriaConditionPath(String basePath) {
        return basePath + ".condition";
    }

    public static String getConditionalIssuanceCriteriaValuePath(String basePath) {
        return basePath + ".value";
    }

    public static String getExpressionIssuanceCriteriaPath(String basePath) {
        return ConnectionPaths.getIssuanceCriteriaPath(basePath) + ".expressionCriteria";
    }

    public static String getExpressionIssuanceCriteriaPath(String basePath, int index) {
        return ConnectionPaths.getExpressionIssuanceCriteriaPath(basePath) + "[" + index + "]";
    }

    public static String getExpressionIssuanceCriteriaExprPath(String basePath) {
        return basePath + ".expression";
    }

    public static String getCredentials() {
        return "credentials";
    }

    public static String getAttributeContractAttributeName(String contractFieldPath, int index) {
        return contractFieldPath + "[" + index + "].name";
    }

    public static String getAttributeContractAttributeNameFormat(String contractFieldPath, int index) {
        return contractFieldPath + "[" + index + "].nameFormat";
    }

    public static String getAttributeContractCoreAttributes(String contractFieldPath) {
        return contractFieldPath + ".coreAttributes";
    }

    public static String getCertForAdminConsole() {
        return "adminConsoleCertRef";
    }

    public static String getCertForAdminConsoleId() {
        return ConnectionPaths.getCertForAdminConsole() + ".id";
    }

    public static String getCertForRuntimeServers() {
        return "runtimeServerCertRef";
    }

    public static String getActiveRuntimeServerCerts() {
        return "activeRuntimeServerCerts";
    }

    public static String getActiveRuntimeServerCerts(int index) {
        return ConnectionPaths.getActiveRuntimeServerCerts() + "[" + index + "]";
    }

    public static String getActiveAdminConsoleCerts() {
        return "activeAdminConsoleCerts";
    }

    public static String getActiveAdminConsoleCerts(int index) {
        return ConnectionPaths.getActiveAdminConsoleCerts() + "[" + index + "]";
    }

    public static String getCertForRuntimeServersId() {
        return ConnectionPaths.getCertForRuntimeServers() + ".id";
    }

    private static String checkEmptyBasePathAndStripLeadingPeriod(String basePath, String extensionPath) {
        String fullPath;
        if (basePath == null) {
            basePath = "";
        }
        if ((fullPath = basePath + extensionPath).startsWith(".")) {
            return fullPath.substring(1);
        }
        return fullPath;
    }

    public static String getArtifactPropertyPath(Role role) {
        return ConnectionPaths.getBrowserSsoPropertyName(role) + ".artifact";
    }

    public static String getOutboundBackChannelAuth() {
        return ConnectionPaths.getCredentials() + ".outboundBackChannelAuth";
    }

    public static String getOutboundBackChannelAuthCert() {
        return ConnectionPaths.getOutboundBackChannelAuth() + ".sslAuthKeyPairRef";
    }

    public static String getOutboundBackChannelAuthCertId() {
        return ConnectionPaths.getOutboundBackChannelAuthCert() + ".id";
    }

    public static String getOutboundBackChannelAuthBasic() {
        return ConnectionPaths.getOutboundBackChannelAuth() + ".httpBasicCredentials";
    }

    public static String getOutboundBackChannelAuthBasicUsername() {
        return ConnectionPaths.getOutboundBackChannelAuthBasic() + ".username";
    }

    public static String getOutboundBackChannelAuthBasicPassword() {
        return ConnectionPaths.getOutboundBackChannelAuthBasic() + ".password";
    }

    public static String getOutboundBackChannelAuthBasicEncryptedPassword() {
        return ConnectionPaths.getOutboundBackChannelAuthBasic() + ".encryptedPassword";
    }

    public static String getInboundBackChannelAuthBasicEncryptedPassword() {
        return ConnectionPaths.getInboundBackChannelAuthBasic() + ".encryptedPassword";
    }

    public static String getInboundBackChannelAuthBasicPassword() {
        return ConnectionPaths.getInboundBackChannelAuthBasic() + ".password";
    }

    public static String getInboundBackChannelAuth() {
        return ConnectionPaths.getCredentials() + ".inboundBackChannelAuth";
    }

    public static String getInboundBackChannelAuthBasic() {
        return ConnectionPaths.getInboundBackChannelAuth() + ".httpBasicCredentials";
    }

    public static String getInboundBackChannelAuthBasicUsername() {
        return ConnectionPaths.getInboundBackChannelAuthBasic() + ".username";
    }

    public static String getInboundBackChannelVerificationSubjectDN() {
        return ConnectionPaths.getInboundBackChannelAuth() + ".verificationSubjectDN";
    }

    public static String getInboundBackChannelVerificationIssuerDN() {
        return ConnectionPaths.getInboundBackChannelAuth() + ".verificationIssuerDN";
    }

    public static String getInboundBackChannelCerts() {
        return ConnectionPaths.getInboundBackChannelAuth() + ".certs";
    }

    public static String getInboundBackChannelCert(int index) {
        return ConnectionPaths.getInboundBackChannelCerts() + "[" + index + "]";
    }

    public static String getInboundBackChannelPrimaryVerificationCert(int index) {
        return ConnectionPaths.getInboundBackChannelCert(index) + ".primaryVerificationCert";
    }

    public static String getDecryptionPolicy() {
        return ConnectionPaths.getBrowserSsoPropertyName(Role.IDP) + ".decryptionPolicy";
    }

    public static String getDecryptionPolicyAssertionEncrypted() {
        return ConnectionPaths.getDecryptionPolicy() + ".assertionEncrypted";
    }

    public static String getDecryptionPolicySloEncryptSubject() {
        return ConnectionPaths.getDecryptionPolicy() + ".sloEncryptSubjectNameID";
    }

    public static String getDecryptionPolicySloSubjectEncrypted() {
        return ConnectionPaths.getDecryptionPolicy() + ".sloSubjectNameIDEncrypted";
    }

    public static String getAttributeQuery() {
        return "attributeQuery";
    }

    public static String getAttributeQueryAttributes() {
        return ConnectionPaths.getAttributeQuery() + ".attributes";
    }

    public static String getAttributeQueryAttributeSources() {
        return ConnectionPaths.getAttributeQuery() + ".attributeSources";
    }

    public static String getAttributeQueryNameMapping() {
        return ConnectionPaths.getAttributeQuery() + ".nameMappings";
    }

    public static String getAttributeQueryNameMapping(int index) {
        return ConnectionPaths.getAttributeQueryNameMapping() + "[" + index + "]";
    }

    public static String getAttributeQueryNameMappingLocalName(int index) {
        return ConnectionPaths.getAttributeQueryNameMapping(index) + ".localName";
    }

    public static String getAttributeQueryNameMappingRemoteName(int index) {
        return ConnectionPaths.getAttributeQueryNameMapping(index) + ".remoteName";
    }

    public static String getAttributeQueryUrl() {
        return ConnectionPaths.getAttributeQuery() + ".url";
    }

    public static String getAuthnContext() {
        return ConnectionPaths.getBrowserSsoPropertyName(Role.IDP) + ".authnContextMappings";
    }

    public static String getAuthnContext(int index) {
        return ConnectionPaths.getAuthnContext() + "[" + index + "]";
    }

    public static String getAuthnContextLocalValue(int index) {
        return ConnectionPaths.getAuthnContext() + "[" + index + "].local";
    }

    public static String getAuthnContextRemoteValue(int index) {
        return ConnectionPaths.getAuthnContext() + "[" + index + "].remote";
    }

    public static String getIdpBrowserSsoOAuthApcId() {
        return ConnectionPaths.getBrowserSsoPropertyName(Role.IDP) + ".oauthAuthenticationPolicyContractRef.id";
    }

    public static String getIdpBrowserSsoOAuthId() {
        return ConnectionPaths.getBrowserSsoPropertyName(Role.IDP) + ".ssoOAuthMapping";
    }

    public static String getIdpBrowserSsoOAttributeSources() {
        return ConnectionPaths.getIdpBrowserSsoOAuthId() + ".attributeSources";
    }

    public static String getJitProvisioning() {
        return ConnectionPaths.getBrowserSsoPropertyName(Role.IDP) + ".jitProvisioning";
    }

    public static String getJitProvisioningEventTrigger() {
        return ConnectionPaths.getJitProvisioning() + ".eventTrigger";
    }

    public static String getJitProvisioningErrorHandling() {
        return ConnectionPaths.getJitProvisioning() + ".errorHandling";
    }

    public static String getJitProvisioningUserAttributes() {
        return ConnectionPaths.getJitProvisioning() + ".userAttributes";
    }

    public static String getJitProvisioningAttributeContract() {
        return ConnectionPaths.getJitProvisioningUserAttributes() + ".attributeContract";
    }

    public static String getJitProvisioningUserRepository() {
        return ConnectionPaths.getJitProvisioning() + ".userRepository";
    }

    public static String getJitProvisioningDataStoreRef() {
        return ConnectionPaths.getJitProvisioningUserRepository() + ".dataStoreRef";
    }

    public static String getJitProvisioningBaseDn() {
        return ConnectionPaths.getJitProvisioningUserRepository() + ".baseDn";
    }

    public static String getJitProvisioningUniqueUserIdFilter() {
        return ConnectionPaths.getJitProvisioningUserRepository() + ".uniqueUserIdFilter";
    }

    public static String getJitProvisioningSqlMethod() {
        return ConnectionPaths.getJitProvisioningUserRepository() + ".sqlMethod";
    }

    public static String getJitProvisioningTable() {
        return ConnectionPaths.getJitProvisioningSqlMethod() + ".table";
    }

    public static String getJitProvisioningTableUniqueIdColumn() {
        return ConnectionPaths.getJitProvisioningTable() + ".uniqueIdColumn";
    }

    public static String getJitProvisioningStoredProcedure() {
        return ConnectionPaths.getJitProvisioningSqlMethod() + ".storedProcedure";
    }

    public static String getJitProvisioningAttributeMapping() {
        return ConnectionPaths.getJitProvisioningUserRepository() + ".repositoryAttributeMapping";
    }

    public static String getJitProvisioningAttributeMapping(int index) {
        return ConnectionPaths.getJitProvisioningAttributeMapping() + "[" + index + "]";
    }

    public static String getIdpOAuthGrantAttributeMapping() {
        return "idpOAuthGrantAttributeMapping";
    }

    public static String getOAuthGrantDataSources() {
        return ConnectionPaths.getIdpOAuthGrantAttributeMapping() + ".accessTokenManagerMappings.attributeSources";
    }

    public static String getBrowserSSOOidcSettings() {
        return ConnectionPaths.getBrowserSsoPropertyName(Role.IDP) + ".oidcProviderSettings";
    }

    public static String getOIDCClientCredentialSettings() {
        return "oidcClientCredential";
    }

    public static String getOIDCClientId() {
        return ConnectionPaths.getOIDCClientCredentialSettings() + ".clientId";
    }

    public static String getOIDCClientSecret() {
        return ConnectionPaths.getOIDCClientCredentialSettings() + ".clientSecret";
    }

    public static String getOIDCEncryptedSecret() {
        return ConnectionPaths.getOIDCClientCredentialSettings() + ".encryptedSecret";
    }

    public static String getAdditionalAllowedEntitiesConfiguration() {
        return "additionalAllowedEntitiesConfiguration";
    }

    public static String getAllowAllEntities() {
        return ConnectionPaths.getAdditionalAllowedEntitiesConfiguration() + ".allowAllEntities";
    }

    public static String getAdditionalAllowedEntities() {
        return ConnectionPaths.getAdditionalAllowedEntitiesConfiguration() + ".additionalAllowedEntities";
    }

    public static String getAdditionalAllowedEntities(int index) {
        return ConnectionPaths.getAdditionalAllowedEntities() + "[" + index + "]";
    }

    public static String getIdpSsoSignAuthnRequests() {
        return ConnectionPaths.getBrowserSsoPropertyName(Role.IDP) + ".signAuthnRequests";
    }

    public static String getIdpAssertionsSigned() {
        return ConnectionPaths.getBrowserSsoPropertyName(Role.IDP) + ".assertionsSigned";
    }

    public static String getAlwaysSignArtifactResponse(Role role) {
        return ConnectionPaths.getBrowserSsoPropertyName(role) + ".alwaysSignArtifactResponse";
    }

    public static String getWsTrust() {
        return "wsTrust";
    }

    public static String getOutboundProvisioning() {
        return "outboundProvisioning";
    }

    public static String getOutboundProvision() {
        return "outboundProvision";
    }

    public static String getInboundProvisioning() {
        return "inboundProvisioning";
    }

    public static String getExtendedProperties() {
        return "extendedProperties";
    }

    public static class InboundProvisionPaths {
        public static String getScimVersion() {
            return ConnectionPaths.getInboundProvisioning() + ".scimVersion";
        }

        public static String getGroupSupport() {
            return ConnectionPaths.getInboundProvisioning() + ".groupSupport";
        }

        public static String getUserRepository() {
            return ConnectionPaths.getInboundProvisioning() + ".userRepository";
        }

        public static String getIdentityStorePluginDescriptorRef() {
            return InboundProvisionPaths.getUserRepository() + ".pluginDescriptorRef";
        }

        public static String getActiveDirectoryDataStoreRef() {
            return InboundProvisionPaths.getUserRepository() + ".dataStoreRef";
        }

        public static String getActiveDirectoryDataStoreRefId() {
            return InboundProvisionPaths.getActiveDirectoryDataStoreRef() + ".id";
        }

        public static String getActiveDirectoryBaseDn() {
            return InboundProvisionPaths.getUserRepository() + ".baseDn";
        }

        public static String getActiveDirectoryUniqueUserIdFilter() {
            return InboundProvisionPaths.getUserRepository() + ".uniqueUserIdFilter";
        }

        public static String getActiveDirectoryUniqueGroupIdFilter() {
            return InboundProvisionPaths.getUserRepository() + ".uniqueGroupIdFilter";
        }

        public static String getCustomSchema() {
            return ConnectionPaths.getInboundProvisioning() + ".customSchema";
        }

        public static String getCustomSchemaAttribute() {
            return InboundProvisionPaths.getCustomSchema() + ".attributes";
        }

        public static String getCustomSchemaAttribute(int index) {
            return InboundProvisionPaths.getCustomSchema() + InboundProvisionPaths.getCustomSchemaAttribute() + "[" + index + "]";
        }

        public static String getCustomScim2Schema() {
            return ConnectionPaths.getInboundProvisioning() + ".customScim2Schema";
        }

        public static String getCustomScim2SchemaAttribute() {
            return InboundProvisionPaths.getCustomScim2Schema() + ".attributes";
        }

        public static String getServiceProviderConfig() {
            return ConnectionPaths.getInboundProvisioning() + ".serviceProviderConfig";
        }

        public static String getDocumentationUri() {
            return InboundProvisionPaths.getServiceProviderConfig() + ".documentationUri";
        }

        public static String getCustomScim2SchemaAttribute(int index) {
            return InboundProvisionPaths.getCustomSchema() + InboundProvisionPaths.getCustomScim2SchemaAttribute() + "[" + index + "]";
        }

        public static String getUsers() {
            return ConnectionPaths.getInboundProvisioning() + ".users";
        }

        public static String getWriteUsers() {
            return InboundProvisionPaths.getUsers() + ".writeUsers";
        }

        public static String getWriteUsersAttributeFulfillment() {
            return InboundProvisionPaths.getWriteUsers() + ".attributeFulfillment";
        }

        public static String getReadUsers() {
            return InboundProvisionPaths.getUsers() + ".readUsers";
        }

        public static String getReadUsersAttributeContract() {
            return InboundProvisionPaths.getReadUsers() + ".attributeContract";
        }

        public static String getReadUsersAttributes() {
            return InboundProvisionPaths.getReadUsers() + ".attributes";
        }

        public static String getReadUsersAttributeFulfillment() {
            return InboundProvisionPaths.getReadUsers() + ".attributeFulfillment";
        }

        public static String getGroups() {
            return ConnectionPaths.getInboundProvisioning() + ".groups";
        }

        public static String getWriteGroups() {
            return InboundProvisionPaths.getGroups() + ".writeGroups";
        }

        public static String getWriteGroupsAttributeFulfillment() {
            return InboundProvisionPaths.getWriteGroups() + ".attributeFulfillment";
        }

        public static String getReadGroups() {
            return InboundProvisionPaths.getGroups() + ".readGroups";
        }

        public static String getReadGroupsAttributeContract() {
            return InboundProvisionPaths.getReadGroups() + ".attributeContract";
        }

        public static String getReadGroupsAttributes() {
            return InboundProvisionPaths.getReadGroups() + ".attributes";
        }

        public static String getReadGroupsAttributeFulfillment() {
            return InboundProvisionPaths.getReadGroups() + ".attributeFulfillment";
        }

        public static String getScimDeleteUsersBehavior() {
            return ConnectionPaths.getInboundProvisioning() + ".actionOnDelete";
        }
    }

    public static class OutboundProvisionPaths {
        public static String getType() {
            return ConnectionPaths.getOutboundProvision() + ".type";
        }

        public static String getConnectorProperties() {
            return ConnectionPaths.getOutboundProvisioning() + ".connectorProperties";
        }

        public static String getTargetSettings() {
            return ConnectionPaths.getOutboundProvisioning() + ".targetSettings";
        }

        public static String getChannels() {
            return ConnectionPaths.getOutboundProvisioning() + ".channels";
        }

        public static String getCustomSchema() {
            return ConnectionPaths.getOutboundProvisioning() + ".customSchema";
        }

        public static String getCustomSchemaAttribute() {
            return OutboundProvisionPaths.getCustomSchema() + ".attributes";
        }

        public static String getCustomSchemaAttribute(int index) {
            return OutboundProvisionPaths.getCustomSchema() + OutboundProvisionPaths.getCustomSchemaAttribute() + "[" + index + "]";
        }

        public static String getChannels(int index) {
            return OutboundProvisionPaths.getChannels() + "[" + index + "]";
        }

        public static String getChannelName(int index) {
            return OutboundProvisionPaths.getChannels(index) + ".name";
        }

        public static String getChannelAttributeMappings(int index) {
            return OutboundProvisionPaths.getChannels(index) + ".attributeMapping";
        }

        public static String getMaxThreads(int index) {
            return OutboundProvisionPaths.getChannels(index) + ".maxThreads";
        }

        public static String getTimeout(int index) {
            return OutboundProvisionPaths.getChannels(index) + ".timeout";
        }

        public static String getChannelSource(int index) {
            return OutboundProvisionPaths.getChannels(index) + ".channelSource";
        }

        public static String getDataSourceId(int index) {
            return OutboundProvisionPaths.getChannelSource(index) + ".dataSourceId";
        }

        public static String getBaseDN(int index) {
            return OutboundProvisionPaths.getChannelSource(index) + ".baseDn";
        }

        public static String getGuidAttributeName(int index) {
            return OutboundProvisionPaths.getChannelSource(index) + ".guidAttributeName";
        }

        public static String getGuidBinary(int index) {
            return OutboundProvisionPaths.getChannelSource(index) + ".isGuidBinary";
        }

        public static String getUserSourceLocation(int index) {
            return OutboundProvisionPaths.getChannelSource(index) + ".userSourceLocation";
        }

        public static String getGroupSourceLocation(int index) {
            return OutboundProvisionPaths.getChannelSource(index) + ".groupSourceLocation";
        }

        public static String getUserGroupDN(int index) {
            return OutboundProvisionPaths.getUserSourceLocation(index) + ".groupDN";
        }

        public static String getUserFilter(int index) {
            return OutboundProvisionPaths.getUserSourceLocation(index) + ".filter";
        }

        public static String getGroupGroupDN(int index) {
            return OutboundProvisionPaths.getGroupSourceLocation(index) + ".groupDN";
        }

        public static String getGroupFilter(int index) {
            return OutboundProvisionPaths.getGroupSourceLocation(index) + ".filter";
        }

        public static String getChangeDetectionSettings(int index) {
            return OutboundProvisionPaths.getChannelSource(index) + ".changeDetectionSettings";
        }

        public static String getUserObjectClass(int index) {
            return OutboundProvisionPaths.getChangeDetectionSettings(index) + ".userObjectClass";
        }

        public static String getGroupObjectClass(int index) {
            return OutboundProvisionPaths.getChangeDetectionSettings(index) + ".groupObjectClass";
        }

        public static String getUsnAttributeName(int index) {
            return OutboundProvisionPaths.getChangeDetectionSettings(index) + ".usnAttributeName";
        }

        public static String getChangedUserAlgo(int index) {
            return OutboundProvisionPaths.getChangeDetectionSettings(index) + ".changedUsersAlgorithm";
        }

        public static String getTimeStampAttributeName(int index) {
            return OutboundProvisionPaths.getChannelSource(index) + ".timeStampAttributeName";
        }

        public static String getIsGuidBinary(int index) {
            return OutboundProvisionPaths.getChannelSource(index) + ".isGuidBinary";
        }

        public static String getGroupMembership(int index) {
            return OutboundProvisionPaths.getChannelSource(index) + ".groupMembershipDetection";
        }

        public static String getMemberOfGroupAttr(int index) {
            return OutboundProvisionPaths.getGroupMembership(index) + ".memberOfGroupAttributeName";
        }

        public static String getGroupMemberAttr(int index) {
            return OutboundProvisionPaths.getGroupMembership(index) + ".groupMemberAttributeName";
        }

        public static String getAccountManagementSettings(int index) {
            return OutboundProvisionPaths.getChannelSource(index) + ".accountManagementSettings";
        }

        public static String getFlagComparisonValue(int index) {
            return OutboundProvisionPaths.getAccountManagementSettings(index) + ".flagComparisonValue";
        }

        public static String getAccountStatusAttributeName(int index) {
            return OutboundProvisionPaths.getAccountManagementSettings(index) + ".accountStatusAttributeName";
        }

        public static String getAccountStatusAlgorithm(int index) {
            return OutboundProvisionPaths.getAccountManagementSettings(index) + ".accountStatusAlgorithm";
        }

        public static String getChannelAttributeMapping(int channelIndex, int attributeIndex) {
            return OutboundProvisionPaths.getChannelAttributeMappings(channelIndex) + ".attributeMapping[" + attributeIndex + "]";
        }

        public static String getChannelAttributeMappingFieldName(int channelIndex, int attributeIndex) {
            return OutboundProvisionPaths.getChannelAttributeMapping(channelIndex, attributeIndex) + ".fieldName";
        }

        public static String getChannelAttributeMappingSaasFieldInfo(int channelIndex, int attributeIndex) {
            return OutboundProvisionPaths.getChannelAttributeMapping(channelIndex, attributeIndex) + ".saasFieldInfo";
        }

        public static String getChannelMappedLdapAttributeName(int channelIndex, int attributeIndex, int mappedLdapIndex) {
            return OutboundProvisionPaths.getChannelAttributeMappingSaasFieldInfo(channelIndex, attributeIndex) + ".attributeNames[" + mappedLdapIndex + "]";
        }

        public static String getChannelAttributeExpression(int channelIndex, int attributeIndex) {
            return OutboundProvisionPaths.getChannelAttributeMappingSaasFieldInfo(channelIndex, attributeIndex) + ".expression";
        }
    }

    public static class WsTrustPaths {
        public static String getPartnerServiceId() {
            return ConnectionPaths.getWsTrust() + ".partnerServiceId";
        }

        public static String getPartnerServiceId(int index) {
            return WsTrustPaths.getPartnerServiceId() + "[" + index + "]";
        }

        public static String getMinutesBefore() {
            return ConnectionPaths.getWsTrust() + ".minutesBefore";
        }

        public static String getMinutesAfter() {
            return ConnectionPaths.getWsTrust() + ".minutesAfter";
        }

        public static String getTokenGeneratorMappings() {
            return ConnectionPaths.getWsTrust() + ".tokenGeneratorMappings";
        }

        public static String getTokenGeneratorMappings(int index) {
            return WsTrustPaths.getTokenProcessorMappings() + "[" + index + "]";
        }

        public static String getDefaultMappingForTokenGeneratorMappings(int index) {
            return WsTrustPaths.getTokenProcessorMappings() + "[" + index + "].defaultMapping";
        }

        public static String getTokenGeneratorMappingsVsid(int index, int vsidIndex) {
            return WsTrustPaths.getTokenGeneratorMappings(index) + ".restrictedVirtualEntityIds[" + vsidIndex + "]";
        }

        public static String getSpAttributeSourceId(int mappingIndex, int attributeSourceIndex) {
            return WsTrustPaths.getTokenGeneratorMappings(mappingIndex) + ".attributeSources[" + attributeSourceIndex + "]";
        }

        public static String getTokenGeneratorMappingRef(int index) {
            return WsTrustPaths.getTokenGeneratorMappings(index) + ".spTokenGeneratorRef";
        }

        public static String getTokenGeneratorMappingRefId(int index) {
            return WsTrustPaths.getTokenGeneratorMappingRef(index) + ".id";
        }

        public static String getTokenProcessorMappings() {
            return ConnectionPaths.getWsTrust() + ".tokenProcessorMappings";
        }

        public static String getTokenProcessorMappings(int index) {
            return WsTrustPaths.getTokenProcessorMappings() + "[" + index + "]";
        }

        public static String getTokenProcessorMappingsVsid(int index, int vsidIndex) {
            return WsTrustPaths.getTokenProcessorMappings(index) + ".restrictedVirtualEntityIds[" + vsidIndex + "]";
        }

        public static String getAttributeSourceId(int mappingIndex, int attributeSourceIndex) {
            return WsTrustPaths.getTokenProcessorMappings(mappingIndex) + ".attributeSources[" + attributeSourceIndex + "]";
        }

        public static String getTokenProcessorMappingRef(int index) {
            return WsTrustPaths.getTokenProcessorMappings(index) + ".idpTokenProcessorRef";
        }

        public static String getTokenProcessorMappingRefId(int index) {
            return WsTrustPaths.getTokenProcessorMappingRef(index) + ".id";
        }

        public static String getRequestContractRef() {
            return ConnectionPaths.getWsTrust() + ".requestContractRef";
        }

        public static String getIsAbort() {
            return ConnectionPaths.getWsTrust() + ".abortIfNotFulfilledFromRequest";
        }

        public static String getAttributeContract() {
            return ConnectionPaths.getWsTrust() + ".attributeContract";
        }

        public static String getAttributeContractCore() {
            return WsTrustPaths.getAttributeContract() + ".coreAttributes";
        }

        public static String getAttributeContractExtended(int index) {
            return WsTrustPaths.getAttributeContract() + ".extendedAttributes[" + index + "]";
        }
    }
}

