/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model.fieldpaths;

import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.model.fieldpaths.SigningSettingsPaths;

public class CredentialsPath {
    public static String getSigningSettings(boolean addPrefix) {
        if (addPrefix) {
            return ConnectionPaths.getCredentials() + ".signingSettings";
        }
        return "signingSettings";
    }

    public static String getDecryptionKeyPair(boolean addPrefix) {
        if (addPrefix) {
            return ConnectionPaths.getCredentials() + ".decryptionKeyPairRef";
        }
        return "decryptionKeyPairRef";
    }

    public static String getSecondaryDecryptionKeyPair(boolean addPrefix) {
        if (addPrefix) {
            return ConnectionPaths.getCredentials() + ".secondaryDecryptionKeyPairRef";
        }
        return "secondaryDecryptionKeyPairRef";
    }

    public static String getVerificationSubjectDN(boolean addPrefix) {
        if (addPrefix) {
            return ConnectionPaths.getCredentials() + ".verificationSubjectDN";
        }
        return "verificationSubjectDN";
    }

    public static String getVerificationIssuerDN(boolean addPrefix) {
        if (addPrefix) {
            return ConnectionPaths.getCredentials() + ".verificationIssuerDN";
        }
        return "verificationIssuerDN";
    }

    public static String getConnectionCerts(boolean addPrefix) {
        if (addPrefix) {
            return ConnectionPaths.getCredentials() + ".certs";
        }
        return "certs";
    }

    public static String getKeyTransportAlg(boolean addPrefix) {
        if (addPrefix) {
            return ConnectionPaths.getCredentials() + ".keyTransportAlgorithm";
        }
        return "keyTransportAlgorithm";
    }

    public static String getEncryptionBlockAlg(boolean addPrefix) {
        if (addPrefix) {
            return ConnectionPaths.getCredentials() + ".blockEncryptionAlgorithm";
        }
        return "blockEncryptionAlgorithm";
    }

    public static String getConnectionCert(int index, boolean addPrefix) {
        return CredentialsPath.getConnectionCerts(addPrefix) + "[" + index + "]";
    }

    public static String getConnectionCertPrimaryVerificationCert(int index, boolean addPrefix) {
        return CredentialsPath.getConnectionCert(index, addPrefix) + ".primaryVerificationCert";
    }

    public static String getConnectionCertSecondaryVerificationCert(int index, boolean addPrefix) {
        return CredentialsPath.getConnectionCert(index, addPrefix) + ".secondaryVerificationCert";
    }

    public static String getConnectionCertX509File(int index, boolean addPrefix) {
        return CredentialsPath.getConnectionCert(index, addPrefix) + ".x509File";
    }

    public static String getConnectionCertX509FileData(int index, boolean addPrefix) {
        return CredentialsPath.getConnectionCertX509File(index, addPrefix) + ".fileData";
    }

    public static String getConnectionCertX509Id(int index, boolean addPrefix) {
        return CredentialsPath.getConnectionCertX509File(index, addPrefix) + ".id";
    }

    public static String getConnectionCertView(int index, boolean addPrefix) {
        return CredentialsPath.getConnectionCert(index, addPrefix) + ".certView";
    }

    public static String getSigningKeyPair(boolean addPrefix) {
        return CredentialsPath.getSigningSettings(addPrefix) + "." + SigningSettingsPaths.getSigningKeyPair();
    }

    public static String getSigningKeyPairId(boolean addPrefix) {
        return CredentialsPath.getSigningSettings(addPrefix) + "." + SigningSettingsPaths.getSigningKeyPairId();
    }

    public static String getSigningAlgorithm(boolean addPrefix) {
        return CredentialsPath.getSigningSettings(addPrefix) + "." + SigningSettingsPaths.getSigningAlgorithm();
    }

    public static String getIncludeCertInSignature(boolean addPrefix) {
        return CredentialsPath.getSigningSettings(addPrefix) + "." + SigningSettingsPaths.getIncludeCertInSignature();
    }

    public static String getIncludeRawKeyInSignature(boolean addPrefix) {
        return CredentialsPath.getSigningSettings(addPrefix) + "." + SigningSettingsPaths.getIncludeRawKeyInSignature();
    }

    public static String getAltSigningKeyPairRef(boolean addPrefix, int index) {
        return CredentialsPath.getSigningSettings(addPrefix) + "." + SigningSettingsPaths.getAltSigningKeyPairRef(index);
    }

    public static String getDecryptionKeyPairId(boolean addPrefix) {
        return CredentialsPath.getDecryptionKeyPair(addPrefix) + ".id";
    }

    public static String getSecondaryDecryptionKeyPairId(boolean addPrefix) {
        return CredentialsPath.getSecondaryDecryptionKeyPair(addPrefix) + ".id";
    }
}

