/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model.oauth;

import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.oauth.ContentEncryptionAlgorithm;
import com.pingidentity.admin.api.model.oauth.EncryptionAlgorithm;
import com.pingidentity.admin.api.model.oauth.SigningAlgorithm;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description="Base Open ID Connect Policy settings.")
public class BaseOIDCPolicy {
    private SigningAlgorithm idTokenSigningAlgorithm;
    private ResourceLink policyGroup;
    private EncryptionAlgorithm encryptionAlgorithm;
    private ContentEncryptionAlgorithm contentEncryptionAlgorithm;

    @ApiModelProperty(position=10, value="The JSON Web Signature [JWS] algorithm required for the ID Token.<br>NONE - No signing algorithm<br>HS256 - HMAC using SHA-256<br>HS384 - HMAC using SHA-384<br>HS512 - HMAC using SHA-512<br>RS256 - RSA using SHA-256<br>RS384 - RSA using SHA-384<br>RS512 - RSA using SHA-512<br>ES256 - ECDSA using P256 Curve and SHA-256<br>ES384 - ECDSA using P384 Curve and SHA-384<br>ES512 - ECDSA using P521 Curve and SHA-512<br>PS256 - RSASSA-PSS using SHA-256 and MGF1 padding with SHA-256<br>PS384 - RSASSA-PSS using SHA-384 and MGF1 padding with SHA-384<br>PS512 - RSASSA-PSS using SHA-512 and MGF1 padding with SHA-512<br>A null value will represent the default algorithm which is RS256.<br>RSASSA-PSS is only supported with Thales Luna, Entrust nShield Connect or Java 11")
    public SigningAlgorithm getIdTokenSigningAlgorithm() {
        return this.idTokenSigningAlgorithm;
    }

    public void setIdTokenSigningAlgorithm(SigningAlgorithm idTokenSigningAlgorithm) {
        if (idTokenSigningAlgorithm != null) {
            this.idTokenSigningAlgorithm = idTokenSigningAlgorithm;
        }
    }

    @ApiModelProperty(position=11, value="The JSON Web Encryption [JWE] encryption algorithm used to encrypt the content encryption key for the ID Token.<br>DIR - Direct Encryption with symmetric key<br>A128KW - AES-128 Key Wrap<br>A192KW - AES-192 Key Wrap<br>A256KW - AES-256 Key Wrap<br>A128GCMKW - AES-GCM-128 key encryption<br>A192GCMKW - AES-GCM-192 key encryption<br>A256GCMKW - AES-GCM-256 key encryption<br>ECDH_ES - ECDH-ES<br>ECDH_ES_A128KW - ECDH-ES with AES-128 Key Wrap<br>ECDH_ES_A192KW - ECDH-ES with AES-192 Key Wrap<br>ECDH_ES_A256KW - ECDH-ES with AES-256 Key Wrap<br>RSA_OAEP - RSAES OAEP<br>RSA_OAEP_256 - RSAES OAEP using SHA-256 and MGF1 with SHA-256")
    public EncryptionAlgorithm getIdTokenEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public void setIdTokenEncryptionAlgorithm(EncryptionAlgorithm encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
    }

    @ApiModelProperty(position=12, value="The JSON Web Encryption [JWE] content encryption algorithm for the ID Token.<br>AES_128_CBC_HMAC_SHA_256 - Composite AES-CBC-128 HMAC-SHA-256<br>AES_192_CBC_HMAC_SHA_384 - Composite AES-CBC-192 HMAC-SHA-384<br>AES_256_CBC_HMAC_SHA_512 - Composite AES-CBC-256 HMAC-SHA-512<br>AES_128_GCM - AES-GCM-128<br>AES_192_GCM - AES-GCM-192<br>AES_256_GCM - AES-GCM-256")
    public ContentEncryptionAlgorithm getIdTokenContentEncryptionAlgorithm() {
        return this.contentEncryptionAlgorithm;
    }

    public void setIdTokenContentEncryptionAlgorithm(ContentEncryptionAlgorithm contentEncryptionAlgorithm) {
        this.contentEncryptionAlgorithm = contentEncryptionAlgorithm;
    }

    @ApiModelProperty(position=20, value="The Open ID Connect policy. A null value will represent the default policy group.")
    public ResourceLink getPolicyGroup() {
        return this.policyGroup;
    }

    public void setPolicyGroup(ResourceLink policyGroup) {
        this.policyGroup = policyGroup;
    }
}

