/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model.oauth;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public enum EncryptionAlgorithm {
    DIR("dir"),
    A128KW("A128KW"),
    A192KW("A192KW"),
    A256KW("A256KW"),
    A128GCMKW("A128GCMKW"),
    A192GCMKW("A192GCMKW"),
    A256GCMKW("A256GCMKW"),
    ECDH_ES("ECDH-ES"),
    ECDH_ES_A128KW("ECDH-ES+A128KW"),
    ECDH_ES_A192KW("ECDH-ES+A192KW"),
    ECDH_ES_A256KW("ECDH-ES+A256KW"),
    RSA_OAEP("RSA-OAEP"),
    RSA_OAEP_256("RSA-OAEP-256");

    private static final Map<String, EncryptionAlgorithm> ID_TO_TYPE_MAP;
    private String id;

    private EncryptionAlgorithm(String encAlg) {
        this.id = encAlg;
    }

    public static Set<String> getKeys() {
        return ID_TO_TYPE_MAP.keySet();
    }

    public String getId() {
        return this.id;
    }

    public static EncryptionAlgorithm getType(String id) {
        return ID_TO_TYPE_MAP.get(id);
    }

    static {
        ID_TO_TYPE_MAP = new HashMap<String, EncryptionAlgorithm>();
        for (EncryptionAlgorithm alg : EncryptionAlgorithm.values()) {
            ID_TO_TYPE_MAP.put(alg.getId(), alg);
        }
    }
}

