/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model.oauth;

import com.pingidentity.admin.api.model.AttributeMapping;
import com.pingidentity.admin.api.model.ParameterValues;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.oauth.OpenIdConnectAttributeContract;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

@ApiModel(description="The set of attributes used to configure an OpenID Connect policy.")
public class OpenIdConnectPolicy {
    public static final int DEFAULT_ID_TOKEN_LIFETIME = 5;
    private String id;
    private String name;
    private Integer idTokenLifetime = 5;
    private OpenIdConnectAttributeContract attributeContract = new OpenIdConnectAttributeContract();
    private AttributeMapping attributeMapping = new AttributeMapping();
    private boolean includeSriInIdToken;
    private boolean includeUserInfoInIdToken;
    private boolean includeSHashInIdToken;
    private boolean includeX5tInIdToken;
    private String idTokenTypHeaderValue;
    private boolean returnIdTokenOnRefreshGrant;
    private boolean returnIdTokenOnTokenExchangeGrant;
    private boolean reissueIdTokenInHybridFlow;
    private boolean allowIdTokenIntrospection;
    private ResourceLink accessTokenManagerRef;
    private Map<String, ParameterValues> scopeAttributeMappings = new HashMap<String, ParameterValues>();
    private Date lastModified;

    @ApiModelProperty(position=10, value="The policy ID used internally.", required=true)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @ApiModelProperty(position=20, value="The name used for display in UI screens.", required=true)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(position=30, value="The access token manager associated with this Open ID Connect policy.", required=true)
    public ResourceLink getAccessTokenManagerRef() {
        return this.accessTokenManagerRef;
    }

    public void setAccessTokenManagerRef(ResourceLink accessTokenManagerRef) {
        this.accessTokenManagerRef = accessTokenManagerRef;
    }

    @ApiModelProperty(position=40, value="The ID Token Lifetime, in minutes. The default value is 5.")
    public Integer getIdTokenLifetime() {
        return this.idTokenLifetime;
    }

    public void setIdTokenLifetime(Integer idTokenLifetime) {
        this.idTokenLifetime = idTokenLifetime;
    }

    @ApiModelProperty(position=50, value="Determines whether a Session Reference Identifier is included in the ID token.")
    public boolean isIncludeSriInIdToken() {
        return this.includeSriInIdToken;
    }

    public void setIncludeSriInIdToken(boolean includeSriInIdToken) {
        this.includeSriInIdToken = includeSriInIdToken;
    }

    @ApiModelProperty(position=60, value="Determines whether the User Info is always included in the ID token.")
    public boolean isIncludeUserInfoInIdToken() {
        return this.includeUserInfoInIdToken;
    }

    public void setIncludeUserInfoInIdToken(boolean includeUserInfoInIdToken) {
        this.includeUserInfoInIdToken = includeUserInfoInIdToken;
    }

    @ApiModelProperty(position=70, value="Determines whether the State Hash should be included in the ID token.")
    public boolean isIncludeSHashInIdToken() {
        return this.includeSHashInIdToken;
    }

    public void setIncludeSHashInIdToken(boolean includeSHashInIdToken) {
        this.includeSHashInIdToken = includeSHashInIdToken;
    }

    @ApiModelProperty(position=71, value="Determines whether the X.509 thumbprint header should be included in the ID Token.")
    public boolean isIncludeX5tInIdToken() {
        return this.includeX5tInIdToken;
    }

    public void setIncludeX5tInIdToken(boolean includeX5tInIdToken) {
        this.includeX5tInIdToken = includeX5tInIdToken;
    }

    @ApiModelProperty(position=72, value="ID Token Type (typ) Header Value.")
    public String getIdTokenTypHeaderValue() {
        return this.idTokenTypHeaderValue;
    }

    public void setIdTokenTypHeaderValue(String idTokenTypHeaderValue) {
        this.idTokenTypHeaderValue = idTokenTypHeaderValue;
    }

    @ApiModelProperty(position=80, value="Determines whether an ID Token should be returned when refresh grant is requested or not.")
    public boolean isReturnIdTokenOnRefreshGrant() {
        return this.returnIdTokenOnRefreshGrant;
    }

    public void setReturnIdTokenOnRefreshGrant(boolean returnIdTokenOnRefreshGrant) {
        this.returnIdTokenOnRefreshGrant = returnIdTokenOnRefreshGrant;
    }

    @ApiModelProperty(position=85, value="Determines whether an ID Token should be returned when token exchange is requested or not.")
    public boolean isReturnIdTokenOnTokenExchangeGrant() {
        return this.returnIdTokenOnTokenExchangeGrant;
    }

    public void setReturnIdTokenOnTokenExchangeGrant(boolean returnIdTokenOnTokenExchangeGrant) {
        this.returnIdTokenOnTokenExchangeGrant = returnIdTokenOnTokenExchangeGrant;
    }

    @ApiModelProperty(position=90, value="Determines whether a new ID Token should be returned during token request of the hybrid flow.")
    public boolean isReissueIdTokenInHybridFlow() {
        return this.reissueIdTokenInHybridFlow;
    }

    public void setReissueIdTokenInHybridFlow(boolean reissueIdTokenInHybridFlow) {
        this.reissueIdTokenInHybridFlow = reissueIdTokenInHybridFlow;
    }

    @ApiModelProperty(position=95, value="Determines whether the introspection endpoint should validate an ID token.")
    public boolean isAllowIdTokenIntrospection() {
        return this.allowIdTokenIntrospection;
    }

    public void setAllowIdTokenIntrospection(boolean allowIdTokenIntrospection) {
        this.allowIdTokenIntrospection = allowIdTokenIntrospection;
    }

    @ApiModelProperty(position=100, value="The list of attributes that will be returned to OAuth clients in response to requests received at the PingFederate UserInfo endpoint.", required=true)
    public OpenIdConnectAttributeContract getAttributeContract() {
        return this.attributeContract;
    }

    public void setAttributeContract(OpenIdConnectAttributeContract attributeContract) {
        this.attributeContract = attributeContract;
    }

    @ApiModelProperty(position=110, value="The attributes mapping from attribute sources to attribute targets.", required=true)
    public AttributeMapping getAttributeMapping() {
        return this.attributeMapping;
    }

    public void setAttributeMapping(AttributeMapping attributeMapping) {
        this.attributeMapping = attributeMapping;
    }

    @ApiModelProperty(position=120, value="The attribute scope mappings from scopes to attribute names.")
    public Map<String, ParameterValues> getScopeAttributeMappings() {
        return this.scopeAttributeMappings;
    }

    public void setScopeAttributeMappings(Map<String, ParameterValues> scopeAttributeMappings) {
        this.scopeAttributeMappings = scopeAttributeMappings;
    }

    @ApiModelProperty(position=130, value="The time at which the policy was last changed. This property is read only and is ignored on PUT and POST requests.")
    public Date getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return new Date(this.lastModified.getTime());
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified == null ? null : new Date(lastModified.getTime());
    }
}

