/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model.oauth;

import java.util.HashMap;
import java.util.Map;

public enum PersistentGrantLifetimeUnit {
    MINUTES("n"),
    DAYS("d"),
    HOURS("h");

    private String id;
    private static final Map<String, PersistentGrantLifetimeUnit> ID_TO_TYPE_MAP;

    private PersistentGrantLifetimeUnit(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public static PersistentGrantLifetimeUnit getType(String id) {
        if ("min".equals(id)) {
            id = "n";
        }
        return ID_TO_TYPE_MAP.get(id);
    }

    static {
        ID_TO_TYPE_MAP = new HashMap<String, PersistentGrantLifetimeUnit>();
        for (PersistentGrantLifetimeUnit grantType : PersistentGrantLifetimeUnit.values()) {
            ID_TO_TYPE_MAP.put(grantType.getId(), grantType);
        }
    }
}

