/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model.oauth;

import java.util.HashMap;
import java.util.Map;

public enum RequestObjectSigningAlgorithm {
    RS256("RS256"),
    RS384("RS384"),
    RS512("RS512"),
    ES256("ES256"),
    ES384("ES384"),
    ES512("ES512"),
    PS256("PS256"),
    PS384("PS384"),
    PS512("PS512");

    private String id;
    private static final Map<String, RequestObjectSigningAlgorithm> ID_TO_TYPE_MAP;

    private RequestObjectSigningAlgorithm(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public static RequestObjectSigningAlgorithm getType(String id) {
        return ID_TO_TYPE_MAP.get(id);
    }

    static {
        ID_TO_TYPE_MAP = new HashMap<String, RequestObjectSigningAlgorithm>();
        for (RequestObjectSigningAlgorithm algorithm : RequestObjectSigningAlgorithm.values()) {
            ID_TO_TYPE_MAP.put(algorithm.getId(), algorithm);
        }
    }
}

