/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model.oauth.exchange;

import com.pingidentity.admin.api.model.oauth.exchange.TokenExchangeProcessorAttribute;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

@ApiModel(description="A set of attributes exposed by an OAuth 2.0 Token Exchange Processor policy.")
public class TokenExchangeProcessorAttributeContract {
    private List<TokenExchangeProcessorAttribute> coreAttributes = new LinkedList<TokenExchangeProcessorAttribute>();
    private List<TokenExchangeProcessorAttribute> extendedAttributes = new LinkedList<TokenExchangeProcessorAttribute>();

    @ApiModelProperty(position=10, value="A list of read-only attributes (for example, subject) that are automatically populated by PingFederate.")
    public List<TokenExchangeProcessorAttribute> getCoreAttributes() {
        return this.coreAttributes;
    }

    @ApiModelProperty(position=20, value="A list of additional attributes.")
    public List<TokenExchangeProcessorAttribute> getExtendedAttributes() {
        return this.extendedAttributes;
    }

    public void setExtendedAttributes(List<TokenExchangeProcessorAttribute> extendedAttributes) {
        this.extendedAttributes = extendedAttributes != null ? extendedAttributes : Collections.emptyList();
    }

    public void addCoreAttribute(TokenExchangeProcessorAttribute coreAttribute) {
        this.coreAttributes.add(coreAttribute);
    }

    public void addExtendedAttribute(TokenExchangeProcessorAttribute extendedAttribute) {
        this.extendedAttributes.add(extendedAttribute);
    }
}

