/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model.plugin;

import com.pingidentity.admin.api.model.plugin.AccessTokenAttribute;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

@ApiModel(description="A set of attributes exposed by an Access Token Manager.")
public class AccessTokenAttributeContract {
    private List<AccessTokenAttribute> coreAttributes = new LinkedList<AccessTokenAttribute>();
    private List<AccessTokenAttribute> extendedAttributes = new LinkedList<AccessTokenAttribute>();
    private Boolean inherited;
    private String defaultSubjectAttribute = null;

    @ApiModelProperty(position=5, value="A list of core token attributes that are associated with the access token management plugin type. This field is read-only and is ignored on POST/PUT.")
    public List<AccessTokenAttribute> getCoreAttributes() {
        return this.coreAttributes;
    }

    public void setCoreAttributes(List<AccessTokenAttribute> coreAttributes) {
        this.coreAttributes = coreAttributes == null ? Collections.emptyList() : coreAttributes;
    }

    @ApiModelProperty(position=10, value="A list of additional token attributes that are associated with this access token management plugin instance.")
    public List<AccessTokenAttribute> getExtendedAttributes() {
        return this.extendedAttributes;
    }

    public void setExtendedAttributes(List<AccessTokenAttribute> extendedAttributes) {
        this.extendedAttributes = extendedAttributes == null ? Collections.emptyList() : extendedAttributes;
    }

    @ApiModelProperty(position=20, value="Whether this attribute contract is inherited from its parent instance. If true, the rest of the properties in this model become read-only. The default value is false.")
    public Boolean isInherited() {
        return this.inherited;
    }

    public void setInherited(Boolean inherited) {
        this.inherited = inherited;
    }

    @ApiModelProperty(position=30, value="Default subject attribute to use for audit logging when validating the access token. Blank value means to use USER_KEY attribute value after grant lookup.")
    public String getDefaultSubjectAttribute() {
        return this.defaultSubjectAttribute;
    }

    public void setDefaultSubjectAttribute(String defaultSubjectAttribute) {
        this.defaultSubjectAttribute = defaultSubjectAttribute;
    }
}

