/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model.plugin;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StringDeserializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description="A plugin configuration field value.")
public class ConfigField {
    @JsonDeserialize(using=StringDeserializer.class)
    private String name;
    private String value;
    private String encryptedValue;
    private Boolean inherited;

    public ConfigField() {
    }

    public ConfigField(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public ConfigField(String name, String value, String encryptedValue) {
        this.name = name;
        this.value = value;
        this.encryptedValue = encryptedValue;
    }

    @ApiModelProperty(position=10, value="The name of the configuration field.", required=true)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(position=20, value="The value for the configuration field. For encrypted or hashed fields, GETs will not return this attribute. To update an encrypted or hashed field, specify the new value in this attribute.")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @ApiModelProperty(position=30, value="For encrypted or hashed fields, this attribute contains the encrypted representation of the field's value, if a value is defined. If you do not want to update the stored value, this attribute should be passed back unchanged.")
    public String getEncryptedValue() {
        return this.encryptedValue;
    }

    public void setEncryptedValue(String encryptedValue) {
        this.encryptedValue = encryptedValue;
    }

    @ApiModelProperty(position=40, value="Whether this field is inherited from its parent instance. If true, the value/encrypted value properties become read-only. The default value is false.")
    public Boolean isInherited() {
        return this.inherited;
    }

    public void setInherited(Boolean inherited) {
        this.inherited = inherited;
    }
}

