/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model.plugin;

import com.pingidentity.admin.api.model.plugin.IdpAdapterAttribute;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

@ApiModel(description="A set of attributes exposed by an IdP adapter.")
public class IdpAdapterAttributeContract {
    private List<IdpAdapterAttribute> coreAttributes = new LinkedList<IdpAdapterAttribute>();
    private List<IdpAdapterAttribute> extendedAttributes = null;
    String uniqueUserKeyAttribute;
    private boolean maskOgnlValues;
    private Boolean inherited;

    @ApiModelProperty(position=10, value="A list of IdP adapter attributes that correspond to the attributes exposed by the IdP adapter type.", required=true)
    public List<IdpAdapterAttribute> getCoreAttributes() {
        return this.coreAttributes;
    }

    public void setCoreAttributes(List<IdpAdapterAttribute> coreAttributes) {
        this.coreAttributes = coreAttributes == null ? Collections.emptyList() : coreAttributes;
    }

    @ApiModelProperty(position=20, value="A list of additional attributes that can be returned by the IdP adapter. The extended attributes are only used if the adapter supports them.")
    public List<IdpAdapterAttribute> getExtendedAttributes() {
        return this.extendedAttributes;
    }

    public void setExtendedAttributes(List<IdpAdapterAttribute> extendedAttributes) {
        this.extendedAttributes = extendedAttributes;
    }

    @ApiModelProperty(position=30, value="The attribute to use for uniquely identify a user's authentication sessions.")
    public String getUniqueUserKeyAttribute() {
        if ("pf_none".equals(this.uniqueUserKeyAttribute)) {
            return null;
        }
        return this.uniqueUserKeyAttribute;
    }

    public void setUniqueUserKeyAttribute(String uniqueUserKeyAttribute) {
        this.uniqueUserKeyAttribute = uniqueUserKeyAttribute;
    }

    @ApiModelProperty(position=40, value="Whether or not all OGNL expressions used to fulfill an outgoing assertion contract should be masked in the logs. Defaults to false.")
    public boolean isMaskOgnlValues() {
        return this.maskOgnlValues;
    }

    public void setMaskOgnlValues(boolean maskOgnlValues) {
        this.maskOgnlValues = maskOgnlValues;
    }

    @ApiModelProperty(position=50, value="Whether this attribute contract is inherited from its parent instance. If true, the rest of the properties in this model become read-only. The default value is false.")
    public Boolean isInherited() {
        return this.inherited;
    }

    public void setInherited(Boolean inherited) {
        this.inherited = inherited;
    }
}

