/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model.resolver;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.jsontype.impl.TypeIdResolverBase;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.pingidentity.admin.api.model.AttributeSource;
import com.pingidentity.admin.api.model.CustomAttributeSource;
import com.pingidentity.admin.api.model.DataStoreType;
import com.pingidentity.admin.api.model.JdbcAttributeSource;
import com.pingidentity.admin.api.model.LdapAttributeSource;

public class AttributeSourceResolver
extends TypeIdResolverBase {
    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.CUSTOM;
    }

    public String idFromValue(Object value) {
        AttributeSource source = (AttributeSource)value;
        return source.getType().toString();
    }

    public String idFromValueAndType(Object value, Class<?> suggestedType) {
        return this.idFromValue(value);
    }

    public JavaType typeFromId(DatabindContext ctx, String id) {
        DataStoreType dsType = null;
        try {
            dsType = DataStoreType.valueOf(id);
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            // empty catch block
        }
        if (dsType == DataStoreType.CUSTOM) {
            return TypeFactory.defaultInstance().constructType(CustomAttributeSource.class);
        }
        if (dsType == DataStoreType.LDAP) {
            return TypeFactory.defaultInstance().constructType(LdapAttributeSource.class);
        }
        if (dsType == DataStoreType.JDBC) {
            return TypeFactory.defaultInstance().constructType(JdbcAttributeSource.class);
        }
        return TypeFactory.defaultInstance().constructType(AttributeSource.class);
    }
}

