/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model.resolver;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.jsontype.impl.TypeIdResolverBase;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.pingidentity.admin.api.model.CustomDataStore;
import com.pingidentity.admin.api.model.DataStore;
import com.pingidentity.admin.api.model.DataStoreType;
import com.pingidentity.admin.api.model.JdbcDataStore;
import com.pingidentity.admin.api.model.LdapDataStore;
import com.pingidentity.admin.api.model.PingOneLdapGatewayDataStore;

public class DataStoreResolver
extends TypeIdResolverBase {
    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.CUSTOM;
    }

    public String idFromValue(Object value) {
        DataStore source = (DataStore)value;
        return source.getType().toString();
    }

    public String idFromValueAndType(Object value, Class<?> suggestedType) {
        return this.idFromValue(value);
    }

    public JavaType typeFromId(DatabindContext ctx, String id) {
        DataStoreType dsType = null;
        try {
            dsType = DataStoreType.valueOf(id);
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            // empty catch block
        }
        if (dsType == DataStoreType.CUSTOM) {
            return TypeFactory.defaultInstance().constructType(CustomDataStore.class);
        }
        if (dsType == DataStoreType.LDAP) {
            return TypeFactory.defaultInstance().constructType(LdapDataStore.class);
        }
        if (dsType == DataStoreType.PING_ONE_LDAP_GATEWAY) {
            return TypeFactory.defaultInstance().constructType(PingOneLdapGatewayDataStore.class);
        }
        if (dsType == DataStoreType.JDBC) {
            return TypeFactory.defaultInstance().constructType(JdbcDataStore.class);
        }
        return TypeFactory.defaultInstance().constructType(DataStore.class);
    }
}

