/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model.sso.idp;

import com.pingidentity.admin.api.model.SourceType;
import java.util.HashMap;
import java.util.Map;
import org.sourceid.saml20.domain.DataSource;

public enum InboundProvisioningUserRepositoryType {
    LDAP(SourceType.LDAP_DATA_STORE, DataSource.DSType.LDAP.getName()),
    IDENTITY_STORE(SourceType.IDENTITY_STORE_USER, "Identity Store User Provisioner");

    private SourceType id;
    private static final Map<SourceType, InboundProvisioningUserRepositoryType> ID_TO_TYPE_MAP;
    private String description;

    private InboundProvisioningUserRepositoryType(SourceType id, String description) {
        this.id = id;
        this.description = description;
    }

    public SourceType getId() {
        return this.id;
    }

    public static InboundProvisioningUserRepositoryType getType(SourceType id) {
        return ID_TO_TYPE_MAP.get((Object)id);
    }

    public String getDescription() {
        return this.description;
    }

    static {
        ID_TO_TYPE_MAP = new HashMap<SourceType, InboundProvisioningUserRepositoryType>();
        for (InboundProvisioningUserRepositoryType userRepositoryType : InboundProvisioningUserRepositoryType.values()) {
            ID_TO_TYPE_MAP.put(userRepositoryType.getId(), userRepositoryType);
        }
    }
}

