/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model.sso.idp;

import com.google.common.collect.ImmutableMap;
import com.pingidentity.admin.api.model.AttributeFulfillmentValue;
import com.pingidentity.admin.api.model.DataStoreRepositoryType;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.sso.idp.DataStoreRepository;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;

@ApiModel(description="LDAP data store user repository.")
public class LdapDataStoreRepository
implements DataStoreRepository {
    private ResourceLink dataStoreRef;
    private String baseDn;
    private String uniqueUserIdFilter;
    private Map<String, AttributeFulfillmentValue> jitRepositoryAttributeMapping = new HashMap<String, AttributeFulfillmentValue>();

    @Override
    @ApiModelProperty(position=10, value="The data store repository type.", required=true)
    public DataStoreRepositoryType getType() {
        return DataStoreRepositoryType.LDAP;
    }

    @Override
    @ApiModelProperty(position=20, value="Reference to the associated data store.", required=true)
    public ResourceLink getDataStoreRef() {
        return this.dataStoreRef;
    }

    @Override
    public void setDataStoreRef(ResourceLink dataStoreRef) {
        this.dataStoreRef = dataStoreRef;
    }

    @ApiModelProperty(position=30, value="The base DN to search from. If not specified, the search will start at the LDAP's root.")
    public String getBaseDn() {
        return this.baseDn;
    }

    public void setBaseDn(String baseDn) {
        this.baseDn = baseDn;
    }

    @ApiModelProperty(position=40, value="The expression that results in a unique user identifier, when combined with the Base DN.", required=true)
    public String getUniqueUserIdFilter() {
        return this.uniqueUserIdFilter;
    }

    public void setUniqueUserIdFilter(String uniqueUserIdFilter) {
        this.uniqueUserIdFilter = uniqueUserIdFilter;
    }

    @Override
    @ApiModelProperty(position=50, value="A list of user repository mappings from attribute names to their fulfillment values.", required=true)
    public Map<String, AttributeFulfillmentValue> getJitRepositoryAttributeMapping() {
        return ImmutableMap.copyOf(this.jitRepositoryAttributeMapping);
    }

    @Override
    public void setJitRepositoryAttributeMapping(Map<String, AttributeFulfillmentValue> attributeContractFulfillment) {
        this.jitRepositoryAttributeMapping = new HashMap<String, AttributeFulfillmentValue>(attributeContractFulfillment);
    }
}

