/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.model.sso.idp;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.pingidentity.admin.api.model.Attribute;
import com.pingidentity.admin.api.model.AttributeFulfillmentValue;
import com.pingidentity.admin.api.model.sso.idp.IdpInboundProvisioningAttributeContract;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@ApiModel(description="User info lookup and respond to incoming SCIM requests configuration.")
public class ReadUsers {
    private IdpInboundProvisioningAttributeContract attributeContract;
    private List<Attribute> attributes = new ArrayList<Attribute>();
    private Map<String, AttributeFulfillmentValue> attributeFulfillment = new HashMap<String, AttributeFulfillmentValue>();

    @ApiModelProperty(position=10, value="A list of attributes that the IdP sends in the SCIM response.", required=true)
    public IdpInboundProvisioningAttributeContract getAttributeContract() {
        return this.attributeContract;
    }

    public void setAttributeContract(IdpInboundProvisioningAttributeContract attributeContract) {
        this.attributeContract = attributeContract == null ? new IdpInboundProvisioningAttributeContract() : attributeContract;
    }

    @ApiModelProperty(position=20, value="A list of LDAP data store attributes to populate a response to a user-provisioning request.", required=true)
    public List<Attribute> getAttributes() {
        return ImmutableList.copyOf(this.attributes);
    }

    public void setAttributes(List<Attribute> attributes) {
        this.attributes = new ArrayList<Attribute>(attributes);
    }

    @ApiModelProperty(position=30, value="A list of user repository mappings from attribute names to their fulfillment values.", required=true)
    public Map<String, AttributeFulfillmentValue> getAttributeFulfillment() {
        return ImmutableMap.copyOf(this.attributeFulfillment);
    }

    public void setAttributeFulfillment(Map<String, AttributeFulfillmentValue> attributeFulfillment) {
        this.attributeFulfillment = new HashMap<String, AttributeFulfillmentValue>(attributeFulfillment);
    }
}

